/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.redstone;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.library.util.ChatUtil;
import com.lothrazar.library.util.LevelWorldUtil;
import com.lothrazar.library.util.TagDataUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LeverRemote
extends ItemBaseCyclic {
    public LeverRemote(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        BlockPos pointer = TagDataUtil.getItemStackBlockPos((ItemStack)stack);
        if (pointer != null) {
            int dimensionTarget = stack.m_41784_().m_128451_("LeverDim");
            tooltip.add((Component)Component.m_237115_((String)(ChatFormatting.RED + ChatUtil.blockPosToString((BlockPos)pointer) + " [" + dimensionTarget + "]")));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        boolean success = false;
        success = this.trigger(stack, worldIn, playerIn);
        if (success) {
            playerIn.m_6674_(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (player.m_36335_().m_41519_((Item)this)) {
            return super.m_6225_(context);
        }
        ItemStack stack = player.m_21120_(context.m_43724_());
        BlockPos pos = context.m_8083_();
        if (world.m_8055_(pos).m_60734_() instanceof LeverBlock) {
            TagDataUtil.setItemStackBlockPos((ItemStack)stack, (BlockPos)pos);
            stack.m_41784_().m_128359_("LeverDim", LevelWorldUtil.dimensionToString((Level)player.m_9236_()));
            if (world.f_46443_) {
                ChatUtil.sendStatusMessage((Player)player, (String)(this.m_5524_() + ".saved"));
            }
            return InteractionResult.SUCCESS;
        }
        boolean success = false;
        success = this.trigger(stack, world, player);
        if (success) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean trigger(ItemStack stack, Level world, Player player) {
        String currentDim;
        BlockPos blockPos = TagDataUtil.getItemStackBlockPos((ItemStack)stack);
        if (blockPos == null) {
            if (world.f_46443_) {
                ChatUtil.sendStatusMessage((Player)player, (String)(this.m_5524_() + ".invalid"));
            }
            return false;
        }
        String dimensionTarget = stack.m_41784_().m_128461_("LeverDim");
        if (dimensionTarget.equalsIgnoreCase(currentDim = LevelWorldUtil.dimensionToString((Level)player.m_9236_()))) {
            BlockState blockState = world.m_8055_(blockPos);
            if (blockState == null || blockState.m_60734_() != Blocks.f_50164_) {
                if (world.f_46443_) {
                    ChatUtil.sendStatusMessage((Player)player, (String)(this.m_5524_() + ".invalid"));
                }
                return false;
            }
            blockState = world.m_8055_(blockPos);
            boolean hasPowerHere = (Boolean)blockState.m_61143_((Property)LeverBlock.f_54622_);
            LevelWorldUtil.toggleLeverPowerState((Level)world, (BlockPos)blockPos, (BlockState)blockState);
            ChatUtil.sendStatusMessage((Player)player, (String)(this.m_5524_() + ".powered." + !hasPowerHere));
            return true;
        }
        return false;
    }
}

