/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.crafting;

import com.lothrazar.cyclic.item.crafting.CraftingBagContainer;
import com.lothrazar.cyclic.item.crafting.CraftingBagContainerProvider;
import com.lothrazar.cyclic.item.crafting.simple.CraftingStickContainer;
import com.lothrazar.cyclic.item.crafting.simple.CraftingStickContainerProvider;
import com.lothrazar.cyclic.item.lunchbox.ContainerProviderLunchbox;
import com.lothrazar.cyclic.item.lunchbox.ItemLunchbox;
import com.lothrazar.cyclic.item.storagebag.ContainerStorageBag;
import com.lothrazar.cyclic.item.storagebag.StorageBagContainerProvider;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.library.packet.PacketFlib;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class PacketItemGui
extends PacketFlib {
    private int slot;
    private Item item;

    public PacketItemGui(int slot, Item item) {
        this.slot = slot;
        this.item = item;
    }

    public static void handle(PacketItemGui message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (message.item == ItemRegistry.LUNCHBOX.get()) {
                ItemStack itemFoodMouse = player.f_36096_.m_142621_();
                if (itemFoodMouse.m_41619_()) {
                    NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new ContainerProviderLunchbox(), buf -> buf.writeInt(message.slot));
                } else if (itemFoodMouse.m_41614_()) {
                    ItemStack lunchbox = player.m_150109_().m_8020_(message.slot);
                    ItemLunchbox.insertFoodIntoLunchbox(lunchbox, itemFoodMouse, player);
                }
            } else if (message.item == ItemRegistry.STORAGE_BAG.get() && !(player.f_36096_ instanceof ContainerStorageBag)) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new StorageBagContainerProvider(message.slot), buf -> buf.writeInt(message.slot));
            } else if (message.item == ItemRegistry.CRAFTING_BAG.get() && !(player.f_36096_ instanceof CraftingBagContainer)) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new CraftingBagContainerProvider(message.slot), buf -> buf.writeInt(message.slot));
            } else if (message.item == ItemRegistry.CRAFTING_STICK.get() && !(player.f_36096_ instanceof CraftingStickContainer)) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new CraftingStickContainerProvider(message.slot), buf -> buf.writeInt(message.slot));
            }
        });
        message.done(ctx);
    }

    public static PacketItemGui decode(FriendlyByteBuf buf) {
        return new PacketItemGui(buf.readInt(), buf.m_130267_().m_41720_());
    }

    public static void encode(PacketItemGui msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.slot);
        buf.m_130055_(new ItemStack((ItemLike)msg.item));
    }
}

