/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.fluid;

import com.lothrazar.cyclic.fluid.block.WaxFluidBlock;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.FluidRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class FluidWaxHolder {
    private static final ResourceLocation FLUID_FLOWING = new ResourceLocation("minecraft:block/water_flow");
    private static final ResourceLocation FLUID_STILL = new ResourceLocation("minecraft:block/water_still");
    private static final String ID = "wax";
    public static RegistryObject<FlowingFluid> STILL = FluidRegistry.FLUIDS.register("wax", () -> new ForgeFlowingFluid.Source(FluidWaxHolder.makeProperties()));
    public static RegistryObject<FlowingFluid> FLOWING = FluidRegistry.FLUIDS.register("wax_flowing", () -> new ForgeFlowingFluid.Flowing(FluidWaxHolder.makeProperties()));
    public static RegistryObject<LiquidBlock> BLOCK = BlockRegistry.BLOCKS.register("wax_block", () -> new WaxFluidBlock((Supplier<? extends FlowingFluid>)STILL, BlockBehaviour.Properties.m_284310_().m_278788_().m_60910_().m_60978_(100.0f).m_222994_()));
    public static RegistryObject<Item> BUCKET = ItemRegistry.ITEMS.register("wax_bucket", () -> new BucketItem(STILL, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static RegistryObject<FluidType> test_fluid_type = FluidRegistry.FLUID_TYPES.register("wax", () -> new FluidType(FluidType.Properties.create()){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return FLUID_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLUID_FLOWING;
                }

                public ResourceLocation getOverlayTexture() {
                    return null;
                }
            });
        }
    });

    private static ForgeFlowingFluid.Properties makeProperties() {
        return new ForgeFlowingFluid.Properties(test_fluid_type, STILL, FLOWING).bucket(BUCKET).block(BLOCK);
    }
}

