/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.filesystem;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.items.ItemStackHandler;

public class CyclicFile {
    public static final String NBTINV = "inv";
    public final UUID playerId;
    public boolean storageVisible = false;
    public boolean todoVisible = false;
    public boolean stepHeight = false;
    public boolean stepHeightForceOff;
    public List<String> todoTasks = new ArrayList<String>();
    public int spectatorTicks = 0;
    public ItemStackHandler inventory = new ItemStackHandler(45);

    public String toString() {
        return "CyclicFile [playerId=" + this.playerId + ", storageVisible=" + this.storageVisible + ", todoVisible=" + this.todoVisible + ", stepHeight=" + this.stepHeight + ", todoTasks=" + this.todoTasks + ", spectatorTicks=" + this.spectatorTicks + ", inventory=" + this.inventory + "]";
    }

    public CyclicFile(UUID playerId) {
        this.playerId = playerId;
    }

    public void read(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_(NBTINV));
        this.spectatorTicks = tag.m_128451_("spectatorTicks");
        this.storageVisible = tag.m_128471_("storageVisible");
        this.stepHeight = tag.m_128471_("stepHeight");
        this.stepHeightForceOff = tag.m_128471_("stepHeightForceOff");
        if (tag.m_128441_("tasks")) {
            ListTag glist = tag.m_128437_("tasks", 10);
            for (int i = 0; i < glist.size(); ++i) {
                CompoundTag row = glist.m_128728_(i);
                this.todoTasks.add(row.m_128461_("todo"));
            }
        }
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(NBTINV, (Tag)this.inventory.serializeNBT());
        tag.m_128405_("spectatorTicks", this.spectatorTicks);
        tag.m_128379_("stepHeight", this.stepHeight);
        tag.m_128379_("stepHeightForceOff", this.stepHeightForceOff);
        tag.m_128379_("storageVisible", this.storageVisible);
        ListTag glist = new ListTag();
        int i = 0;
        for (String t : this.todoTasks) {
            CompoundTag row = new CompoundTag();
            row.m_128405_("index", i);
            row.m_128359_("todo", t);
            glist.add((Object)row);
        }
        tag.m_128365_("tasks", (Tag)glist);
        return tag;
    }

    public void toggleStepHeight() {
        boolean bl = this.stepHeight = !this.stepHeight;
        if (!this.stepHeight) {
            this.stepHeightForceOff = true;
        }
    }
}

