/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.library.enchant.EnchantmentFlib;
import com.lothrazar.library.util.EntityUtil;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VenomEnchant
extends EnchantmentFlib {
    public static final int TICKSPERLEVEL = 60;
    public static final String ID = "venom";
    public static ForgeConfigSpec.BooleanValue CFG;

    public VenomEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 2;
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        int level;
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getTarget() instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)event.getTarget();
        Player attacker = event.getEntity();
        ItemStack main = attacker.m_21205_();
        ItemStack off = attacker.m_21206_();
        int mainLevel = -1;
        int offLevel = -1;
        if (main != null && EnchantmentHelper.m_44831_((ItemStack)main).containsKey((Object)this)) {
            mainLevel = (Integer)EnchantmentHelper.m_44831_((ItemStack)main).get((Object)this);
        }
        if (off != null && EnchantmentHelper.m_44831_((ItemStack)off).containsKey((Object)this)) {
            offLevel = (Integer)EnchantmentHelper.m_44831_((ItemStack)off).get((Object)this);
        }
        if ((level = Math.max(mainLevel, offLevel)) > 0) {
            EntityUtil.addOrMergePotionEffect((LivingEntity)target, (MobEffectInstance)new MobEffectInstance(MobEffects.f_19614_, 60 * level, level - 1));
        }
    }
}

