/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.solidifier.RecipeSolidifier;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TextureRegistry;
import com.lothrazar.library.gui.EnergyBar;
import com.lothrazar.library.gui.TexturedProgress;
import com.lothrazar.library.util.ChatUtil;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class SolidifierRecipeCategory
implements IRecipeCategory<RecipeSolidifier> {
    private static final int FONT = -1;
    private static final ResourceLocation ID = new ResourceLocation("cyclic", "solidifier");
    static final RecipeType<RecipeSolidifier> TYPE = new RecipeType(ID, RecipeSolidifier.class);
    private IDrawable gui;
    private IDrawable icon;
    private Font font;
    private EnergyBar bar;
    private TexturedProgress progress;

    public SolidifierRecipeCategory(IGuiHelper helper) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/solidifier_recipe.png"), 0, 0, 169, 69).setTextureSize(169, 69).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.SOLIDIFIER.get()));
        this.bar = new EnergyBar(this.font, 64000);
        this.progress = new TexturedProgress(this.font, 63, 25, 24, 17, TextureRegistry.ARROW);
        this.bar.guiTop = -4;
        this.bar.guiLeft = -2;
    }

    public Component getTitle() {
        return ChatUtil.ilang((String)((Block)BlockRegistry.SOLIDIFIER.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public RecipeType<RecipeSolidifier> getRecipeType() {
        return TYPE;
    }

    public void draw(RecipeSolidifier recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics ms, double mouseX, double mouseY) {
        ms.m_280488_(this.font, recipe.getEnergy().getRfPertick() + " RF/t", 55, 10, -1);
        this.bar.draw(ms, (float)recipe.getEnergy().getEnergyTotal());
        this.progress.draw(ms, 0.0f);
        this.bar.renderHoveredToolTip(ms, (int)mouseX, (int)mouseY, recipe.getEnergy().getEnergyTotal());
        this.progress.renderHoveredToolTip(ms, (int)mouseX, (int)mouseY, recipe.getEnergy().getTicks());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeSolidifier recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 34, 7).addIngredients(recipe.at(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 34, 25).addIngredients(recipe.at(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 34, 43).addIngredients(recipe.at(2));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 104, 25).addItemStack(recipe.result);
        List matchingFluids = recipe.fluidIngredient.getMatchingFluids();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 4, 25).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, matchingFluids)).setFluidRenderer(4000L, false, 16, 16);
    }
}

