/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.workbench;

import com.lothrazar.cyclic.block.workbench.TileWorkbench;
import com.lothrazar.cyclic.data.IContainerCraftingAction;
import com.lothrazar.cyclic.registry.MenuTypeRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;

public class ContainerWorkbench
extends RecipeBookMenu<CraftingContainer>
implements IContainerCraftingAction {
    private TileWorkbench tile;
    public static final int GRID_START_X = 30;
    public static final int GRID_START_Y = 17;
    public static final int OUTPUT_START_X = 124;
    public static final int OUTPUT_START_Y = 35;
    public static final int GRID_NUM_ROWS = 3;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer craftResult = new ResultContainer();
    private final Player player;
    private final ContainerLevelAccess worldPosCallable;
    private boolean doneOpening = false;

    public ContainerWorkbench(int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)MenuTypeRegistry.WORKBENCH.get(), windowId);
        this.tile = (TileWorkbench)world.m_7702_(pos);
        this.player = player;
        this.worldPosCallable = ContainerLevelAccess.m_39289_((Level)world, (BlockPos)pos);
        this.m_38897_((Slot)new ResultSlot(playerInventory.f_35978_, this.craftMatrix, (Container)this.craftResult, 0, 124, 35));
        int index = 0;
        for (int rowPos = 0; rowPos < 3; ++rowPos) {
            for (int colPos = 0; colPos < 3; ++colPos) {
                this.craftMatrix.m_6836_(index, this.tile.inventory.getStackInSlot(index));
                this.m_38897_(new Slot((Container)this.craftMatrix, index, 30 + colPos * 18, 17 + rowPos * 18));
                ++index;
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)playerInventory, l, 8 + l * 18, 142));
        }
        this.doneOpening = true;
        this.m_6199_(this.tile);
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_5816_(StackedContents itemHelperIn) {
        this.craftMatrix.m_5809_(itemHelperIn);
    }

    public void m_6650_() {
        this.craftMatrix.m_6211_();
        this.craftResult.m_6211_();
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> recipeIn) {
        return recipeIn.m_5818_((Container)this.craftMatrix, this.player.m_9236_());
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return 3;
    }

    public int m_6656_() {
        return 3;
    }

    public int m_6653_() {
        return 10;
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int s) {
        return false;
    }

    public void m_6199_(Container inventoryIn) {
        if (!this.doneOpening) {
            return;
        }
        ItemStackHandler inventory = this.tile.inventory;
        for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            inventory.extractItem(i, inventory.getSlotLimit(i), false);
            inventory.insertItem(i, this.craftMatrix.m_8020_(i), false);
        }
        this.worldPosCallable.m_39292_((wrld, posIn) -> ContainerWorkbench.updateCraftingResult(this.f_38840_, this.m_182424_(), wrld, this.player, this.craftMatrix, this.craftResult));
    }

    @Override
    public ItemStack transferStack(Player playerIn, int index) {
        return this.m_7648_(playerIn, index);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        try {
            int playerStart = 10;
            int playerEnd = 46;
            ItemStack itemstack = ItemStack.f_41583_;
            Slot slot = (Slot)this.f_38839_.get(index);
            if (slot != null && slot.m_6657_()) {
                ItemStack stack = slot.m_7993_();
                itemstack = stack.m_41777_();
                if (index < playerStart ? !this.m_38903_(stack, playerStart, playerEnd, false) : index <= playerEnd && !this.m_38903_(stack, 1, 10, false)) {
                    return ItemStack.f_41583_;
                }
                if (stack.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                if (stack.m_41613_() == itemstack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(playerIn, stack);
            }
            return itemstack;
        }
        catch (Exception e) {
            return ItemStack.f_41583_;
        }
    }

    protected static void updateCraftingResult(int id, int stateId, Level world, Player player, CraftingContainer inventory, ResultContainer inventoryResult) {
        if (!world.f_46443_) {
            CraftingRecipe recipe;
            ServerPlayer sp = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional optional = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)inventory, world);
            if (optional.isPresent() && inventoryResult.m_40135_(world, sp, (Recipe)(recipe = (CraftingRecipe)optional.get()))) {
                itemstack = recipe.m_5874_((Container)inventory, world.m_9598_());
            }
            inventoryResult.m_6836_(0, itemstack);
            sp.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(id, stateId, 0, itemstack));
        }
    }

    @Override
    public CraftingContainer getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public ResultContainer getCraftResult() {
        return this.craftResult;
    }
}

