/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.scaffolding;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.library.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockScaffolding
extends BlockCyclic {
    private static final double CHANCE_CRUMBLE = 0.5;
    private static final double CLIMB_SPEED = 0.31;
    private static final double OFFSET = 0.125;
    public static final VoxelShape AABB = Block.m_49796_((double)0.125, (double)0.125, (double)0.125, (double)15.875, (double)15.875, (double)15.875);
    private boolean doesAutobreak = true;

    public BlockScaffolding(BlockBehaviour.Properties properties, boolean autobreak) {
        super(properties.m_60978_(0.1f).m_60977_().m_60955_().m_60918_(SoundRegistry.SCAFFOLD));
        this.doesAutobreak = autobreak;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.doesAutobreak && random.m_188500_() < 0.5) {
            worldIn.m_46961_(pos, true);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!(entityIn instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)entityIn;
        if (!entityIn.f_19862_) {
            return;
        }
        EntityUtil.tryMakeEntityClimb((Level)worldIn, (LivingEntity)entity, (double)0.31);
    }
}

