/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.laser;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.laser.TileLaser;
import com.lothrazar.library.render.type.FakeBlockRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderLaser
implements BlockEntityRenderer<TileLaser> {
    public RenderLaser(BlockEntityRendererProvider.Context d) {
    }

    public void render(TileLaser te, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int partialTicks, int destroyStage) {
        if (te.requiresRedstone() && !te.isPowered()) {
            return;
        }
        try {
            RenderLaser.draw(te, matrixStack, iRenderTypeBuffer);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("RenderLaser.java ", e);
        }
    }

    public static Vector3f adjustBeamToEyes(Vector3f from, Vector3f to, BlockPos tile) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vector3f vectP = new Vector3f((float)player.m_20185_() - (float)tile.m_123341_(), (float)player.m_20188_() - (float)tile.m_123342_(), (float)player.m_20189_() - (float)tile.m_123343_());
        Vector3f vectS = new Vector3f((Vector3fc)from);
        vectS.sub((Vector3fc)vectP);
        Vector3f vectE = new Vector3f((Vector3fc)to);
        vectE.sub((Vector3fc)from);
        Vector3f adjustedVec = new Vector3f((Vector3fc)vectS);
        adjustedVec.cross((Vector3fc)vectE);
        adjustedVec.normalize();
        return adjustedVec;
    }

    public static void draw(TileLaser tile, PoseStack matrixStackIn, MultiBufferSource bufferIn) throws Exception {
        BlockPos posTarget = tile.getPosTarget();
        if (posTarget == null || posTarget.equals((Object)BlockPos.f_121853_)) {
            return;
        }
        matrixStackIn.m_85836_();
        Matrix4f positionMatrix = matrixStackIn.m_85850_().m_252922_();
        BlockPos tilePos = tile.m_58899_();
        Vector3f from = new Vector3f((float)posTarget.m_123341_() + 0.5f - (float)tilePos.m_123341_(), (float)posTarget.m_123342_() + 0.5f - (float)tilePos.m_123342_(), (float)posTarget.m_123343_() + 0.5f - (float)tilePos.m_123343_());
        Vector3f to = new Vector3f(tile.xOffset.getOffset(), tile.yOffset.getOffset(), tile.zOffset.getOffset());
        VertexConsumer builder = bufferIn.m_6299_(FakeBlockRenderTypes.LASER_MAIN_BEAM);
        RenderLaser.drawDirewolfLaser(builder, positionMatrix, from, to, tile.getRed(), tile.getGreen(), tile.getBlue(), tile.getAlpha(), tile.getThick(), tilePos);
        float coreThick = 0.01f;
        RenderLaser.drawDirewolfLaser(builder, positionMatrix, from, to, 1.0f, 1.0f, 1.0f, tile.getAlpha(), 0.01f, tilePos);
        matrixStackIn.m_85849_();
    }

    public static void drawDirewolfLaser(VertexConsumer builder, Matrix4f positionMatrix, Vector3f from, Vector3f to, float r, float g, float b, float alpha, float thickness, BlockPos tilePos) {
        float v = 1.0f;
        Vector3f adjustedVec = RenderLaser.adjustBeamToEyes(from, to, tilePos);
        adjustedVec.mul(thickness);
        Vector3f p1 = new Vector3f((Vector3fc)from);
        p1.add((Vector3fc)adjustedVec);
        Vector3f p2 = new Vector3f((Vector3fc)from);
        p2.sub((Vector3fc)adjustedVec);
        Vector3f p3 = new Vector3f((Vector3fc)to);
        p3.add((Vector3fc)adjustedVec);
        Vector3f p4 = new Vector3f((Vector3fc)to);
        p4.sub((Vector3fc)adjustedVec);
        builder.m_252986_(positionMatrix, p1.x(), p1.y(), p1.z()).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(positionMatrix, p3.x(), p3.y(), p3.z()).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(positionMatrix, p4.x(), p4.y(), p4.z()).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(positionMatrix, p2.x(), p2.y(), p2.z()).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
    }

    public boolean shouldRenderOffScreen(TileLaser te) {
        return true;
    }
}

