/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.fanslab;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.fanslab.TileFanSlab;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFanSlab
extends BlockCyclic
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    protected static final VoxelShape AABB_CEILING_X_ON = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_CEILING_Z_ON = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_FLOOR_X_ON = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape AABB_FLOOR_Z_ON = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape AABB_NORTH_ON = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SOUTH_ON = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape AABB_WEST_ON = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_EAST_ON = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_CEILING_X_OFF = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_CEILING_Z_OFF = Block.m_49796_((double)5.0, (double)14.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0);
    protected static final VoxelShape AABB_FLOOR_X_OFF = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape AABB_FLOOR_Z_OFF = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape AABB_NORTH_OFF = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SOUTH_OFF = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape AABB_WEST_OFF = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_EAST_OFF = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);

    public BlockFanSlab(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(0.8f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(FACE, (Comparable)AttachFace.WALL));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        switch ((AttachFace)state.m_61143_(FACE)) {
            case FLOOR: {
                if (direction.m_122434_() == Direction.Axis.X) {
                    return powered ? AABB_FLOOR_X_ON : AABB_FLOOR_X_OFF;
                }
                return powered ? AABB_FLOOR_Z_ON : AABB_FLOOR_Z_OFF;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return powered ? AABB_EAST_ON : AABB_EAST_OFF;
                    }
                    case WEST: {
                        return powered ? AABB_WEST_ON : AABB_WEST_OFF;
                    }
                    case SOUTH: {
                        return powered ? AABB_SOUTH_ON : AABB_SOUTH_OFF;
                    }
                }
                return powered ? AABB_NORTH_ON : AABB_NORTH_OFF;
            }
        }
        if (direction.m_122434_() == Direction.Axis.X) {
            return powered ? AABB_CEILING_X_ON : AABB_CEILING_X_OFF;
        }
        return powered ? AABB_CEILING_Z_ON : AABB_CEILING_Z_OFF;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileFanSlab(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockFanSlab.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TileRegistry.FANSLAB.get()), (BlockEntityTicker)(world.f_46443_ ? TileFanSlab::clientTick : TileFanSlab::serverTick));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)HORIZONTAL_FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HORIZONTAL_FACING}).m_61104_(new Property[]{POWERED}).m_61104_(new Property[]{FACE}).m_61104_(new Property[]{WATERLOGGED});
    }
}

