/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.library.util.RenderTextUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class EnderShelfRenderer
implements BlockEntityRenderer<TileEnderShelf> {
    public EnderShelfRenderer(BlockEntityRendererProvider.Context d) {
    }

    public void render(TileEnderShelf tile, float partialTicks, PoseStack ms, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Direction side = tile.getCurrentFacing();
        RenderTextUtil.alignRendering((PoseStack)ms, (Direction)side);
        tile.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                this.renderSlot(tile, i, h.getStackInSlot(i), ms, buffer, combinedLightIn, combinedOverlayIn);
            }
        });
    }

    private void renderSlot(TileEnderShelf tile, int slot, ItemStack stack, PoseStack ms, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (stack.m_41619_()) {
            return;
        }
        float sh = 16.0f;
        boolean color = false;
        double x = 0.09375;
        double y = (float)(3 * slot + 2) / 16.0f;
        double z = 1.01;
        float scaleNum = 0.094f;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        if (tile.renderStyle == TileEnderShelf.RenderTextType.STACK) {
            float sp = 0.19f;
            float xf = 0.16f + (float)slot * 0.19f / 1.5f;
            float yf = 1.0f - (0.88f - (float)slot * 0.19f);
            float size = 0.12f;
            ms.m_85836_();
            ms.m_252880_(0.0f, 0.0f, 1.0f);
            ms.m_252880_(xf, yf, 0.0f);
            ms.m_85841_(size, size, size);
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.NONE, combinedLightIn, combinedOverlayIn, ms, buffer, tile.m_58904_(), combinedLightIn);
            ms.m_85849_();
        } else if (tile.renderStyle == TileEnderShelf.RenderTextType.TEXT) {
            String displayName;
            Map enchantments;
            Iterator xf;
            if ((tile.inventory.nameCache[slot] == null || tile.inventory.nameCache[slot].isEmpty()) && (xf = (enchantments = EnchantmentHelper.m_44882_((ListTag)EnchantedBookItem.m_41163_((ItemStack)stack))).entrySet().iterator()).hasNext()) {
                Map.Entry entry = xf.next();
                tile.inventory.nameCache[slot] = ((Enchantment)entry.getKey()).m_44700_(((Integer)entry.getValue()).intValue()).getString();
            }
            if ((displayName = tile.inventory.nameCache[slot]) == null || displayName.isEmpty()) {
                displayName = stack.m_41786_().getString();
            }
            float scaleName = 0.02832999f + 0.1f * this.getScaleFactor(displayName);
            ms.m_85836_();
            ms.m_85837_(0.07375, y + 0.06, 1.01);
            ms.m_85841_(0.0625f * scaleName, -0.0625f * scaleName, 5.0E-5f);
            fontRenderer.m_271703_(displayName, 0.0f, 0.0f, 0, false, ms.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
            ms.m_85849_();
        }
        if (tile.renderStyle != TileEnderShelf.RenderTextType.NONE) {
            ms.m_85836_();
            ms.m_85837_((double)0.17475f, y, 1.01);
            ms.m_85841_(0.005875f, -0.005875f, 5.0E-5f);
            String displayCount = "x" + stack.m_41613_();
            fontRenderer.m_271703_(displayCount, 110.0f, 0.0f, 0, false, ms.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
            ms.m_85849_();
        }
    }

    private float getScaleFactor(String displayName) {
        int lv = 17;
        if (displayName.length() > lv) {
            return 1.0f - 0.027777778f * (float)(displayName.length() - lv);
        }
        return 1.0f;
    }
}

