/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.dice;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.util.LevelWorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TileDice
extends TileBlockEntityCyclic {
    private static final int TICKS_MAX_SPINNING = 45;
    private static final int TICKS_PER_CHANGE = 4;
    private int spinningIfZero = 1;

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileDice tile) {
        tile.tick();
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileDice e) {
        e.tick();
    }

    public TileDice(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.DICE.get(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        tag.m_128405_("spinningIfZero", this.spinningIfZero);
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        this.spinningIfZero = tag.m_128451_("spinningIfZero");
        super.m_183515_(tag);
    }

    public void startSpinning() {
        this.timer = 45;
        this.spinningIfZero = 0;
    }

    public void tick() {
        if (this.timer == 0) {
            this.spinningIfZero = 1;
            this.updateComparatorOutputLevel();
        } else {
            --this.timer;
            if (this.timer % 4 == 0) {
                this.spinningIfZero = 0;
                Direction fac = LevelWorldUtil.getRandomDirection((RandomSource)this.f_58857_.f_46441_);
                BlockState stateold = this.f_58857_.m_8055_(this.f_58858_);
                BlockState newstate = (BlockState)stateold.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)fac);
                this.f_58857_.m_46597_(this.f_58858_, newstate);
            }
        }
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case SPINNING: {
                return this.spinningIfZero;
            }
        }
        return -1;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case SPINNING: {
                this.spinningIfZero = value;
            }
        }
    }

    static enum Fields {
        TIMER,
        SPINNING;

    }
}

