/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.item;

import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.TileCableBase;
import com.lothrazar.cyclic.block.cable.item.ContainerCableItem;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilDirection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableItem
extends TileCableBase
implements MenuProvider {
    private static final int FLOW_QTY = 64;
    private int extractQty = 64;
    ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() == ItemRegistry.FILTER_DATA.get();
        }
    };
    private Map<Direction, LazyOptional<IItemHandler>> flow = new ConcurrentHashMap<Direction, LazyOptional<IItemHandler>>();

    public TileCableItem(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ITEM_PIPE.get(), pos, state);
        for (Direction f : Direction.values()) {
            this.flow.put(f, (LazyOptional<IItemHandler>)LazyOptional.of(TileCableItem::createHandler));
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCableItem e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCableItem e) {
        e.tick();
    }

    private static ItemStackHandler createHandler() {
        return new ItemStackHandler(1);
    }

    public void tick() {
        for (Direction extractSide : Direction.values()) {
            EnumConnectType connection = (EnumConnectType)((Object)this.m_58900_().m_61143_((Property)CableBase.FACING_TO_PROPERTY_MAP.get(extractSide)));
            if (!connection.isExtraction()) continue;
            IItemHandler sideHandler = (IItemHandler)this.flow.get(extractSide).orElse(null);
            this.tryExtract(sideHandler, extractSide, this.extractQty, this.filter);
        }
        this.normalFlow();
    }

    private void normalFlow() {
        block0: for (Direction incomingSide : Direction.values()) {
            IItemHandler sideHandler = (IItemHandler)this.flow.get(incomingSide).orElse(null);
            for (Direction outgoingSide : UtilDirection.getAllInDifferentOrder()) {
                if (outgoingSide == incomingSide || !this.canPushToSide(outgoingSide) || !this.moveItems(outgoingSide, 64, sideHandler)) continue;
                continue block0;
            }
            if (!this.canPushToSide(incomingSide)) continue;
            this.moveItems(incomingSide, 64, sideHandler);
        }
    }

    private boolean canPushToSide(Direction outgoingSide) {
        EnumConnectType outgoingConnection = (EnumConnectType)((Object)this.m_58900_().m_61143_((Property)CableBase.FACING_TO_PROPERTY_MAP.get(outgoingSide)));
        return !outgoingConnection.isExtraction() && !outgoingConnection.isBlocked();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side != null && cap == ForgeCapabilities.ITEM_HANDLER && !CableBase.isCableBlocked(this.m_58900_(), side)) {
            return this.flow.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<IItemHandler> sidedCap : this.flow.values()) {
            sidedCap.invalidate();
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.extractQty = tag.m_128451_("extractCount");
        for (Direction f : Direction.values()) {
            LazyOptional<IItemHandler> item = this.flow.get(f);
            item.ifPresent(h -> {
                CompoundTag itemTag = tag.m_128469_("item" + f.toString());
                ((INBTSerializable)h).deserializeNBT((Tag)itemTag);
            });
        }
        this.filter.deserializeNBT(tag.m_128469_("filter"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("filter", (Tag)this.filter.serializeNBT());
        tag.m_128405_("extractCount", this.extractQty);
        for (Direction f : Direction.values()) {
            LazyOptional<IItemHandler> item = this.flow.get(f);
            item.ifPresent(h -> {
                CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
                tag.m_128365_("item" + f.toString(), (Tag)compound);
            });
        }
        super.m_183515_(tag);
    }

    @Override
    public void setField(int field, int value) {
        this.extractQty = value;
    }

    @Override
    public int getField(int field) {
        return this.extractQty;
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.ITEM_PIPE.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerCableItem(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }
}

