/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.anvilvoid;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.anvilvoid.ContainerAnvilVoid;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.fluid.FluidXpJuiceHolder;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.cap.ItemStackHandlerWrapper;
import com.lothrazar.library.util.FluidHelpersUtil;
import com.lothrazar.library.util.SoundUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class TileAnvilVoid
extends TileBlockEntityCyclic
implements MenuProvider,
WorldlyContainer {
    public static final int CAPACITY = 16000;
    public static ForgeConfigSpec.IntValue FLUIDPAY;
    ItemStackHandler inputSlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41793_() || stack.m_41720_() == Items.f_42690_;
        }
    };
    ItemStackHandler outputSlots = new ItemStackHandler(1);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    public FluidTankBase tank = new FluidTankBase(this, 16000, p -> FluidHelpersUtil.matches((Fluid)p.getFluid(), DataTags.EXPERIENCE));
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);

    public TileAnvilVoid(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ANVILVOID.get(), pos, state);
        this.needsRedstone = 1;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileAnvilVoid e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileAnvilVoid e) {
        e.tick();
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.ANVILVOID.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerAnvilVoid(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        super.m_183515_(tag);
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (!this.outputSlots.getStackInSlot(0).m_41619_()) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        boolean doCost = false;
        if (stack.m_41720_() == Items.f_42690_) {
            this.inputSlots.extractItem(0, 1, false);
            this.outputSlots.insertItem(0, new ItemStack((ItemLike)Items.f_42517_), false);
            doCost = true;
        } else if (stack.m_41783_() != null && stack.m_41783_().m_128441_("Enchantments") && !stack.m_204117_(DataTags.ANVIL_IMMUNE)) {
            stack.m_41783_().m_128473_("Enchantments");
            this.outputSlots.insertItem(0, stack.m_41777_(), false);
            this.inputSlots.extractItem(0, stack.m_41613_(), false);
            doCost = true;
        }
        if (doCost && (Integer)FLUIDPAY.get() > 0) {
            SoundUtil.playSound((Level)this.f_58857_, (BlockPos)this.f_58858_, (SoundEvent)SoundEvents.f_11887_);
            Fluid newFluid = (Fluid)FluidXpJuiceHolder.STILL.get();
            if (!this.getFluid().isEmpty()) {
                newFluid = this.getFluid().getFluid();
            }
            this.tank.fill(new FluidStack(newFluid, ((Integer)FLUIDPAY.get()).intValue()), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    public int[] m_7071_(Direction direction) {
        return this.inventory.getSlotsForFace(direction);
    }

    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        return this.inventory.canPlaceItemThroughFace(i, itemStack, direction);
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return this.inventory.canTakeItemThroughFace(i, itemStack, direction);
    }

    static enum Fields {
        TIMER,
        REDSTONE;

    }
}

