/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.init.ModItems;
import reliquary.item.ItemBase;
import reliquary.item.util.IPotionItem;
import reliquary.reference.Settings;
import reliquary.util.TooltipBuilder;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionMap;
import reliquary.util.potions.XRPotionHelper;

public class PotionItemBase
extends ItemBase
implements IPotionItem {
    public PotionItemBase() {
        super(new Item.Properties());
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !XRPotionHelper.getPotionEffectsFromStack(stack).isEmpty();
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack potion, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        TooltipBuilder.of(tooltip).potionEffects(potion);
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Settings.COMMON.disable.disablePotions.get())) {
            return;
        }
        for (PotionEssence essence : PotionMap.uniquePotions) {
            ItemStack potion = new ItemStack((ItemLike)this, 1);
            XRPotionHelper.addPotionEffectsToStack(potion, essence.getEffects());
            itemConsumer.accept(potion);
        }
    }

    @Override
    public List<MobEffectInstance> getEffects(ItemStack stack) {
        return XRPotionHelper.getPotionEffectsFromStack(stack);
    }
}

