/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import reliquary.item.ICreativeTabItemGenerator;

public class MercyCrossItem
extends SwordItem
implements ICreativeTabItemGenerator {
    private static final String WEAPON_MODIFIER_NAME = "Weapon modifier";

    public MercyCrossItem() {
        super((Tier)Tiers.GOLD, 3, -2.4f, new Item.Properties().m_41487_(1).m_41503_(64));
        MinecraftForge.EVENT_BUS.addListener(this::handleDamage);
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack cross, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).m_130940_(ChatFormatting.GRAY));
    }

    public float m_43299_() {
        return 0.0f;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.builder().putAll(super.getAttributeModifiers(slot, stack)).put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, WEAPON_MODIFIER_NAME, 6.0, AttributeModifier.Operation.ADDITION)).put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, WEAPON_MODIFIER_NAME, (double)-2.4f, AttributeModifier.Operation.ADDITION)).build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    private void handleDamage(AttackEntityEvent event) {
        Entity entity;
        if (event.getEntity().m_9236_().f_46443_ || !((entity = event.getTarget()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (event.getEntity().m_21205_().m_41720_() != this) {
            return;
        }
        this.updateAttackDamageModifier(target, event.getEntity());
    }

    private void updateAttackDamageModifier(LivingEntity target, Player player) {
        double dmg = this.isUndead(target) ? 12.0 : 6.0;
        AttributeInstance attackAttribute = player.m_21051_(Attributes.f_22281_);
        if (attackAttribute != null && (attackAttribute.m_22111_(f_41374_) == null || attackAttribute.m_22111_(f_41374_).m_22218_() != dmg)) {
            attackAttribute.m_22120_(f_41374_);
            attackAttribute.m_22118_(new AttributeModifier(f_41374_, WEAPON_MODIFIER_NAME, dmg, AttributeModifier.Operation.ADDITION));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity monster) {
        Mob mob;
        if (monster instanceof Mob && this.isUndead((LivingEntity)(mob = (Mob)monster))) {
            monster.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, monster.m_20185_() + (double)(player.m_9236_().f_46441_.m_188501_() - 0.5f), monster.m_20186_() + (double)(player.m_9236_().f_46441_.m_188501_() - 0.5f) + (double)(monster.m_20206_() / 2.0f), monster.m_20189_() + (double)(player.m_9236_().f_46441_.m_188501_() - 0.5f), 0.0, 0.0, 0.0);
        }
        return super.onLeftClickEntity(stack, player, monster);
    }

    private boolean isUndead(LivingEntity e) {
        return e.m_6336_() == MobType.f_21641_;
    }
}

