/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.List;
import java.util.function.Function;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.item.AlkahestryTomeItem;
import reliquary.item.AngelheartVialItem;
import reliquary.item.AngelicFeatherItem;
import reliquary.item.AphroditePotionItem;
import reliquary.item.BulletItem;
import reliquary.item.DestructionCatalystItem;
import reliquary.item.EmperorChaliceItem;
import reliquary.item.EnderStaffItem;
import reliquary.item.FertilePotionItem;
import reliquary.item.FortuneCoinItem;
import reliquary.item.GlacialStaffItem;
import reliquary.item.GlowingWaterItem;
import reliquary.item.HandgunItem;
import reliquary.item.HarvestRodItem;
import reliquary.item.HeroMedallionItem;
import reliquary.item.HolyHandGrenadeItem;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.item.IceMagusRodItem;
import reliquary.item.InfernalChaliceItem;
import reliquary.item.InfernalClawsItem;
import reliquary.item.InfernalTearItem;
import reliquary.item.ItemBase;
import reliquary.item.KrakenShellItem;
import reliquary.item.LanternOfParanoiaItem;
import reliquary.item.MagazineItem;
import reliquary.item.MagicbaneItem;
import reliquary.item.MercyCrossItem;
import reliquary.item.MidasTouchstoneItem;
import reliquary.item.MobCharmBeltItem;
import reliquary.item.MobCharmFragmentItem;
import reliquary.item.MobCharmItem;
import reliquary.item.PhoenixDownItem;
import reliquary.item.PotionEssenceItem;
import reliquary.item.PotionItemBase;
import reliquary.item.PyromancerStaffItem;
import reliquary.item.RendingGaleItem;
import reliquary.item.RodOfLyssaItem;
import reliquary.item.SalamanderEyeItem;
import reliquary.item.SerpentStaffItem;
import reliquary.item.ShearsOfWinterItem;
import reliquary.item.SojournerStaffItem;
import reliquary.item.TippedArrowItem;
import reliquary.item.TwilightCloakItem;
import reliquary.item.VoidTearItem;
import reliquary.item.WitchHatItem;
import reliquary.item.WitherlessRoseItem;
import reliquary.item.block.BlockItemBase;
import reliquary.item.block.InterdictionTorchItem;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.XRPotionHelper;

public class ItemDescriptionBuilder {
    private ItemDescriptionBuilder() {
    }

    public static void addIngredientInfo(IRecipeRegistration registration) {
        ItemDescriptionBuilder.registerItemDescription(registration, (AlkahestryTomeItem)ModItems.ALKAHESTRY_TOME.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (MercyCrossItem)ModItems.MERCY_CROSS.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (AngelheartVialItem)ModItems.ANGELHEART_VIAL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (AngelicFeatherItem)ModItems.ANGELIC_FEATHER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (AphroditePotionItem)ModItems.APHRODITE_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (PotionEssenceItem)ModItems.POTION_ESSENCE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (DestructionCatalystItem)ModItems.DESTRUCTION_CATALYST.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (EmperorChaliceItem)ModItems.EMPEROR_CHALICE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (EnderStaffItem)ModItems.ENDER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (FertilePotionItem)ModItems.FERTILE_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (FortuneCoinItem)ModItems.FORTUNE_COIN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (GlacialStaffItem)ModItems.GLACIAL_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (GlowingWaterItem)ModItems.GLOWING_WATER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (HolyHandGrenadeItem)ModItems.HOLY_HAND_GRENADE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (HandgunItem)ModItems.HANDGUN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.GRIP_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.BARREL_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.HAMMER_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (HarvestRodItem)ModItems.HARVEST_ROD.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (HeroMedallionItem)ModItems.HERO_MEDALLION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (IceMagusRodItem)ModItems.ICE_MAGUS_ROD.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (InfernalChaliceItem)ModItems.INFERNAL_CHALICE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (InfernalClawsItem)ModItems.INFERNAL_CLAWS.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (InfernalTearItem)ModItems.INFERNAL_TEAR.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (KrakenShellItem)ModItems.KRAKEN_SHELL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (MidasTouchstoneItem)ModItems.MIDAS_TOUCHSTONE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (PhoenixDownItem)ModItems.PHOENIX_DOWN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (PyromancerStaffItem)ModItems.PYROMANCER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (RendingGaleItem)ModItems.RENDING_GALE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (RodOfLyssaItem)ModItems.ROD_OF_LYSSA.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (SojournerStaffItem)ModItems.SOJOURNER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (TippedArrowItem)ModItems.TIPPED_ARROW.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (VoidTearItem)ModItems.VOID_TEAR.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (WitchHatItem)ModItems.WITCH_HAT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (WitherlessRoseItem)ModItems.WITHERLESS_ROSE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.EMPTY_POTION_VIAL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (PotionItemBase)ModItems.POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (PotionItemBase)ModItems.SPLASH_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (PotionItemBase)ModItems.LINGERING_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (MobCharmBeltItem)ModItems.MOB_CHARM_BELT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.ZOMBIE_HEART.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.SQUID_BEAK.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.RIB_BONE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.CATALYZING_GLAND.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.CHELICERAE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.SLIME_PEARL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.KRAKEN_SHELL_FRAGMENT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.BAT_WING.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.WITHERED_RIB.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.MOLTEN_CORE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.EYE_OF_THE_STORM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.FERTILE_ESSENCE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.FROZEN_CORE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.NEBULOUS_HEART.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.INFERNAL_CLAW.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.GUARDIAN_SPIKE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.CRIMSON_CLOTH.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (LanternOfParanoiaItem)ModItems.LANTERN_OF_PARANOIA.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (MagicbaneItem)ModItems.MAGICBANE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (SalamanderEyeItem)ModItems.SALAMANDER_EYE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (SerpentStaffItem)ModItems.SERPENT_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ShearsOfWinterItem)ModItems.SHEARS_OF_WINTER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (TwilightCloakItem)ModItems.TWILIGHT_CLOAK.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (ItemBase)ModItems.GLOWING_BREAD.get());
        ItemDescriptionBuilder.registerCharmFragmentItemsDescription(registration);
        ItemDescriptionBuilder.registerCharmItemsDescription(registration);
        ItemDescriptionBuilder.registerItemDescription(registration, (MagazineItem)ModItems.EMPTY_MAGAZINE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (BulletItem)ModItems.EMPTY_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (MagazineItem)ModItems.NEUTRAL_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (MagazineItem)ModItems.EXORCISM_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (MagazineItem)ModItems.BLAZE_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (MagazineItem)ModItems.ENDER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (MagazineItem)ModItems.CONCUSSIVE_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (MagazineItem)ModItems.BUSTER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (MagazineItem)ModItems.SEEKER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (MagazineItem)ModItems.SAND_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (MagazineItem)ModItems.STORM_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (BulletItem)ModItems.NEUTRAL_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (BulletItem)ModItems.EXORCISM_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (BulletItem)ModItems.BLAZE_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (BulletItem)ModItems.ENDER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (BulletItem)ModItems.CONCUSSIVE_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (BulletItem)ModItems.BUSTER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (BulletItem)ModItems.SEEKER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (BulletItem)ModItems.SAND_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (BulletItem)ModItems.STORM_BULLET.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (BlockItemBase)ModBlocks.ALKAHESTRY_ALTAR_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (BlockItemBase)ModBlocks.APOTHECARY_CAULDRON_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (BlockItemBase)ModBlocks.APOTHECARY_MORTAR_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (InterdictionTorchItem)ModBlocks.INTERDICTION_TORCH_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (BlockItemBase)ModBlocks.WRAITH_NODE_ITEM.get());
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, ModBlocks.PEDESTAL_ITEMS.values().stream().map(ro -> new ItemStack((ItemLike)ro.get())).toList(), "pedestal");
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, ModBlocks.PASSIVE_PEDESTAL_ITEMS.values().stream().map(ro -> new ItemStack((ItemLike)ro.get())).toList(), "passive_pedestal");
    }

    private static <I extends Item> void registerItemDescription(IRecipeRegistration registration, I item) {
        NonNullList subItems = NonNullList.m_122779_();
        ((ICreativeTabItemGenerator)item).addCreativeTabItems(arg_0 -> subItems.add(arg_0));
        if (!subItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)subItems, new String[0]);
        }
    }

    private static void addStacksIngredientInfo(IRecipeRegistration registration, Item item, List<ItemStack> items, String ... additionalKeys) {
        String[] langKeys;
        String regName = RegistryHelper.getRegistryName(item).m_135815_();
        if (additionalKeys.length > 0) {
            langKeys = new String[additionalKeys.length + 1];
            langKeys[0] = regName;
            System.arraycopy(additionalKeys, 0, langKeys, 1, additionalKeys.length);
        } else {
            langKeys = new String[]{regName};
        }
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, items, langKeys);
    }

    private static void addStacksIngredientInfo(IRecipeRegistration registration, List<ItemStack> items, String ... langKeys) {
        registration.addIngredientInfo(items, (IIngredientType)VanillaTypes.ITEM_STACK, ItemDescriptionBuilder.getTranslationKeys(langKeys));
    }

    private static Component[] getTranslationKeys(String ... langKeys) {
        Component[] components = new Component[langKeys.length];
        for (int i = 0; i < langKeys.length; ++i) {
            components[i] = Component.m_237115_((String)String.format("jei.%s.description.%s", "reliquary", langKeys[i].replace('/', '.')));
        }
        return components;
    }

    private static void registerCharmFragmentItemsDescription(IRecipeRegistration registration) {
        MobCharmFragmentItem item = (MobCharmFragmentItem)ModItems.MOB_CHARM_FRAGMENT.get();
        ItemDescriptionBuilder.registerCharmBasedItems(registration, item, MobCharmFragmentItem::getEntityEggRegistryName);
    }

    private static void registerCharmItemsDescription(IRecipeRegistration registration) {
        MobCharmItem item = (MobCharmItem)ModItems.MOB_CHARM.get();
        ItemDescriptionBuilder.registerCharmBasedItems(registration, item, MobCharmItem::getEntityEggRegistryName);
    }

    private static <I extends Item> void registerCharmBasedItems(IRecipeRegistration registration, I item, Function<ItemStack, ResourceLocation> getEntityRegistryName) {
        NonNullList subItems = NonNullList.m_122779_();
        ((ICreativeTabItemGenerator)item).addCreativeTabItems(arg_0 -> subItems.add(arg_0));
        for (ItemStack subItem : subItems) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(getEntityRegistryName.apply(subItem));
            if (entityType == null) continue;
            String path = RegistryHelper.getRegistryName(item).m_135815_();
            String itemDescriptionKey = String.format("jei.%s.description.%s", "reliquary", path.replace('/', '.'));
            String entityName = entityType.m_20676_().getString();
            registration.addIngredientInfo((Object)subItem, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237110_((String)itemDescriptionKey, (Object[])new Object[]{entityName, entityName})});
        }
    }

    private static <I extends Item> void registerPotionAmmoItemsDescription(IRecipeRegistration registration, I item) {
        NonNullList subItems = NonNullList.m_122779_();
        NonNullList potionItems = NonNullList.m_122779_();
        ((ICreativeTabItemGenerator)item).addCreativeTabItems(arg_0 -> subItems.add(arg_0));
        for (ItemStack subItem : subItems) {
            if (XRPotionHelper.getPotionEffectsFromStack(subItem).isEmpty()) continue;
            potionItems.add((Object)subItem);
        }
        if (!potionItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)potionItems, "ammo_potion");
        }
        subItems = NonNullList.m_122779_();
        NonNullList nonPotionItems = NonNullList.m_122779_();
        ((ICreativeTabItemGenerator)item).addCreativeTabItems(arg_0 -> subItems.add(arg_0));
        for (ItemStack subItem : subItems) {
            if (!XRPotionHelper.getPotionEffectsFromStack(subItem).isEmpty()) continue;
            nonPotionItems.add((Object)subItem);
        }
        if (!nonPotionItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)nonPotionItems, new String[0]);
        }
    }
}

