/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.recipe.conditions;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityExistsCondition
implements ICondition {
    private static final ResourceLocation ID = new ResourceLocation("flib", "entity_exists");
    private ResourceLocation entityId;

    public EntityExistsCondition(ResourceLocation resourceLocation) {
        this.entityId = resourceLocation;
    }

    public String toString() {
        return "entity_exists(\"" + this.entityId + "\")";
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        return this.entityId != null && ForgeRegistries.ENTITY_TYPES.containsKey(this.entityId);
    }

    public static class Serializer
    implements IConditionSerializer<EntityExistsCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, EntityExistsCondition value) {
            json.addProperty("value", value.entityId.toString());
        }

        public EntityExistsCondition read(JsonObject json) {
            String entityId = json.get("value").getAsString();
            return new EntityExistsCondition(new ResourceLocation(entityId));
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

