/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.IModDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.ProviderSettings;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import org.jetbrains.annotations.Nullable;

public abstract class ModRecipeProvider
extends RecipeProvider
implements IModDataProvider {
    private final ProviderSettings _settings;

    protected ModRecipeProvider(String name, PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup, ResourceLocationBuilder modLocationRoot) {
        super(output);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name must not be null or empty");
        Preconditions.checkNotNull((Object)output, (Object)"Output must not be null");
        Preconditions.checkNotNull(registryLookup, (Object)"Registry lookup must not be null");
        Preconditions.checkNotNull((Object)modLocationRoot, (Object)"Mod location root must not be null");
        this._settings = new ProviderSettings(name, output, registryLookup, modLocationRoot);
    }

    protected ResourceLocationBuilder craftingRoot() {
        return this.root().appendPath("crafting");
    }

    protected ResourceLocationBuilder blastingRoot() {
        return this.root().appendPath("blasting");
    }

    protected ResourceLocationBuilder smeltingRoot() {
        return this.root().appendPath("smelting");
    }

    protected ResourceLocationBuilder cookingRoot() {
        return this.root().appendPath("cooking");
    }

    protected ResourceLocationBuilder smokingRoot() {
        return this.root().appendPath("smoking");
    }

    protected ResourceLocationBuilder stonecuttingRoot() {
        return this.root().appendPath("stonecutting");
    }

    protected ResourceLocationBuilder smithingRoot() {
        return this.root().appendPath("smithing");
    }

    protected ResourceLocationBuilder miscRoot() {
        return this.root().appendPath("misc");
    }

    protected ShapedRecipeBuilder shaped(RecipeCategory category, Supplier<? extends ItemLike> result, int amount) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than zero");
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)result.get(), (int)amount);
    }

    protected ShapedRecipeBuilder shaped(RecipeCategory category, Supplier<? extends ItemLike> result) {
        return this.shaped(category, result, 1);
    }

    protected ShapelessRecipeBuilder shapeless(RecipeCategory category, Supplier<? extends ItemLike> result, int amount) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than zero");
        return ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)result.get(), (int)amount);
    }

    protected ShapelessRecipeBuilder shapeless(RecipeCategory category, Supplier<? extends ItemLike> result) {
        return this.shapeless(category, result, 1);
    }

    protected SimpleCookingRecipeBuilder campfireCooking(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, float experience, int cookingTime) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        ModRecipeProvider.validateCookingParameters(ingredient, experience, cookingTime);
        return SimpleCookingRecipeBuilder.m_247020_((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (float)experience, (int)cookingTime);
    }

    protected SimpleCookingRecipeBuilder blasting(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, float experience, int cookingTime) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        ModRecipeProvider.validateCookingParameters(ingredient, experience, cookingTime);
        return SimpleCookingRecipeBuilder.m_245681_((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (float)experience, (int)cookingTime);
    }

    protected SimpleCookingRecipeBuilder smelting(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, float experience, int cookingTime) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        ModRecipeProvider.validateCookingParameters(ingredient, experience, cookingTime);
        return SimpleCookingRecipeBuilder.m_246179_((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (float)experience, (int)cookingTime);
    }

    protected SimpleCookingRecipeBuilder smoking(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, float experience, int cookingTime) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        ModRecipeProvider.validateCookingParameters(ingredient, experience, cookingTime);
        return SimpleCookingRecipeBuilder.m_246159_((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (float)experience, (int)cookingTime);
    }

    protected SingleItemRecipeBuilder stonecutting(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, int amount) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than zero");
        return SingleItemRecipeBuilder.m_246944_((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (int)amount);
    }

    protected SingleItemRecipeBuilder stonecutting(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient) {
        return this.stonecutting(category, result, ingredient, 1);
    }

    protected SmithingTransformRecipeBuilder smithing(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient template, Ingredient base, Ingredient addition) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        Preconditions.checkNotNull((Object)template, (Object)"Template must not be null");
        Preconditions.checkNotNull((Object)base, (Object)"Base must not be null");
        Preconditions.checkNotNull((Object)addition, (Object)"Addition must not be null");
        return SmithingTransformRecipeBuilder.m_266555_((Ingredient)template, (Ingredient)base, (Ingredient)addition, (RecipeCategory)category, (Item)result.get().m_5456_());
    }

    protected SmithingTrimRecipeBuilder smithingTrim(RecipeCategory category, Ingredient template, Ingredient base, Ingredient addition) {
        Preconditions.checkNotNull((Object)category, (Object)"Category must not be null");
        Preconditions.checkNotNull((Object)template, (Object)"Template must not be null");
        Preconditions.checkNotNull((Object)base, (Object)"Base must not be null");
        Preconditions.checkNotNull((Object)addition, (Object)"Addition must not be null");
        return SmithingTrimRecipeBuilder.m_266182_((Ingredient)template, (Ingredient)base, (Ingredient)addition, (RecipeCategory)category);
    }

    protected static ICondition not(ICondition condition) {
        Preconditions.checkNotNull((Object)condition, (Object)"Condition must not be null");
        return new NotCondition(condition);
    }

    protected static ICondition and(ICondition ... conditions) {
        return new AndCondition(conditions);
    }

    protected static ICondition or(ICondition ... conditions) {
        return new OrCondition(conditions);
    }

    protected static ICondition modLoaded(String modId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)modId) ? 1 : 0) != 0, (Object)"Mod ID must not be null or empty");
        return new ModLoadedCondition(modId);
    }

    protected static ICondition allModsLoaded(String ... modIds) {
        return ModRecipeProvider.and((ICondition[])Stream.of(modIds).map(ModRecipeProvider::modLoaded).toArray(ICondition[]::new));
    }

    protected static ICondition anyModsLoaded(String ... modIds) {
        return ModRecipeProvider.or((ICondition[])Stream.of(modIds).map(ModRecipeProvider::modLoaded).toArray(ICondition[]::new));
    }

    protected ConditionalRecipe.Builder conditional(ICondition ... conditions) {
        if (0 == conditions.length) {
            throw new IllegalArgumentException("At least one condition must be provided");
        }
        ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder;
    }

    protected void withFallback(Consumer<FinishedRecipe> builder, ResourceLocation name, TagKey<Item> tag, @Nullable ResourceLocation fallbackName, @Nullable TagKey<Item> fallbackTag, Function<TagKey<Item>, ShapedRecipeBuilder> recipe) {
        if (null == fallbackTag || null == fallbackName) {
            recipe.apply(tag).m_126140_(builder, name);
        } else {
            this.conditional(ModRecipeProvider.not((ICondition)new TagEmptyCondition(tag.f_203868_()))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)recipe.apply(tag)).m_176498_(arg_0)).build(builder, name);
            this.conditional(new ICondition[]{new TagEmptyCondition(tag.f_203868_())}).addRecipe(arg_0 -> ((ShapedRecipeBuilder)recipe.apply(fallbackTag)).m_176498_(arg_0)).build(builder, fallbackName);
        }
    }

    protected void storageBlock3x3(Consumer<FinishedRecipe> builder, String name, String group, ResourceLocation toStorageId, RecipeCategory toStorageCategory, Supplier<? extends ItemLike> storage, ResourceLocation toComponentId, RecipeCategory toComponentCategory, Supplier<? extends ItemLike> component) {
        this.shapeless(toStorageCategory, storage).m_126211_(component.get(), 9).m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)component.get())).m_126140_(builder, toStorageId);
        this.shapeless(toComponentCategory, component, 9).m_126209_(storage.get()).m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)storage.get())).m_126140_(builder, toComponentId);
    }

    protected void storageBlock3x3(Consumer<FinishedRecipe> builder, String name, String group, RecipeCategory toStorageCategory, Supplier<? extends ItemLike> storage, RecipeCategory toComponentCategory, Supplier<? extends ItemLike> component) {
        ResourceLocationBuilder crafting = this.craftingRoot().append(name);
        this.storageBlock3x3(builder, name, group, crafting.buildWithSuffix("_component_to_storage"), toStorageCategory, storage, crafting.buildWithSuffix("_storage_to_component"), toComponentCategory, component);
    }

    protected void storageBlock2x2(Consumer<FinishedRecipe> builder, String name, String group, ResourceLocation toStorageId, RecipeCategory toStorageCategory, Supplier<? extends ItemLike> storage, ResourceLocation toComponentId, RecipeCategory toComponentCategory, Supplier<? extends ItemLike> component) {
        this.shaped(toStorageCategory, storage).m_126127_(Character.valueOf('X'), component.get()).m_126130_("XX").m_126130_("XX").m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)component.get())).m_126140_(builder, toStorageId);
        this.shapeless(toComponentCategory, component, 4).m_126209_(storage.get()).m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)storage.get())).m_126140_(builder, toComponentId);
    }

    protected void storageBlock2x2(Consumer<FinishedRecipe> builder, String name, String group, RecipeCategory toStorageCategory, Supplier<? extends ItemLike> storage, RecipeCategory toComponentCategory, Supplier<? extends ItemLike> component) {
        ResourceLocationBuilder crafting = this.craftingRoot().append(name);
        this.storageBlock2x2(builder, name, group, crafting.buildWithSuffix("_component_to_storage2x2"), toStorageCategory, storage, crafting.buildWithSuffix("_storage2x2_to_component"), toComponentCategory, component);
    }

    protected void nugget(Consumer<FinishedRecipe> builder, String name, String group, ResourceLocation toIngotId, RecipeCategory toIngotCategory, Supplier<? extends ItemLike> ingot, ResourceLocation toNuggetId, RecipeCategory toNuggetCategory, Supplier<? extends ItemLike> nugget) {
        this.shapeless(toIngotCategory, ingot).m_126211_(nugget.get(), 9).m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)nugget.get())).m_126140_(builder, toIngotId);
        this.shapeless(toNuggetCategory, nugget, 9).m_126209_(ingot.get()).m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingot.get())).m_126140_(builder, toNuggetId);
    }

    protected void nugget(Consumer<FinishedRecipe> builder, String name, String group, RecipeCategory toIngotCategory, Supplier<? extends ItemLike> ingot, RecipeCategory toNuggetCategory, Supplier<? extends ItemLike> nugget) {
        ResourceLocationBuilder crafting = this.craftingRoot().append(name);
        this.nugget(builder, name, group, crafting.buildWithSuffix("_nugget_to_ingot"), toIngotCategory, ingot, crafting.buildWithSuffix("_ingot_to_nugget"), toNuggetCategory, nugget);
    }

    @Override
    public void provideData() {
    }

    @Override
    public CompletableFuture<?> processData(CachedOutput cache, HolderLookup.Provider registryLookup) {
        return super.m_213708_(cache);
    }

    @Override
    public ProviderSettings getSettings() {
        return this._settings;
    }

    private static void validateResultAndCategory(RecipeCategory category, Supplier<? extends ItemLike> result) {
        Preconditions.checkNotNull((Object)category, (Object)"Category must not be null");
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
    }

    private static void validateCookingParameters(Ingredient ingredient, float experience, int cookingTime) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"ingredient must not be null");
        Preconditions.checkArgument((experience >= 0.0f ? 1 : 0) != 0, (Object)"Experience must be greater than or equal to zero");
        Preconditions.checkArgument((cookingTime >= 0 ? 1 : 0) != 0, (Object)"Amount must be greater than or equal to zero");
    }
}

