/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal;

import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.MultiblockRegistrySafeReferent;
import it.zerono.mods.zerocore.internal.network.Network;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockRegistry;
import it.zerono.mods.zerocore.lib.recipe.ModRecipeType;
import it.zerono.mods.zerocore.lib.tag.TagList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public final class Lib {
    public static final ResourceLocationBuilder TEXTURES_LOCATION = ZeroCore.ROOT_LOCATION.appendPath("textures");
    public static final ResourceLocationBuilder GUI_TEXTURES_LOCATION = TEXTURES_LOCATION.appendPath("gui");
    public static final String NAME_RESULT = "result";
    public static final String NAME_INGREDIENT = "ingredient";
    public static final String NAME_ITEM = "item";
    public static final String NAME_FLUID = "fluid";
    public static final String NAME_TAG = "tag";
    public static final String NAME_COUNT = "count";
    public static final String NAME_NBT_TAG = "nbt";
    public static final String NAME_TYPE = "type";
    public static final String NAME_CONDITIONS = "conditions";
    private static boolean s_resourceReloaded;

    public static void initialize() {
        s_resourceReloaded = false;
        IEventBus bus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        bus.addListener(Lib::onRegisterRecipeSerializer);
        bus = (IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get();
        bus.addListener(Lib::onAddReloadListener);
        bus.addListener(Lib::onWorldTick);
        TagList.initialize();
    }

    public static boolean shouldInvalidateResourceCache() {
        return s_resourceReloaded;
    }

    public static <Controller extends IMultiblockController<Controller>> IMultiblockRegistry<Controller> createMultiblockRegistry() {
        return (IMultiblockRegistry)DistExecutor.safeRunForDist(() -> MultiblockRegistrySafeReferent::client, () -> MultiblockRegistrySafeReferent::server);
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> CompletableFuture.runAsync(() -> {
            s_resourceReloaded = true;
            ModRecipeType.invalidate();
            Network.sendClearRecipeCommand();
        }, gameExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0)));
    }

    @SubscribeEvent
    public static void onRegisterRecipeSerializer(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.RECIPE_TYPES, helper -> ModRecipeType.onRegisterRecipes((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side.isServer() && TickEvent.Phase.END == event.phase) {
            s_resourceReloaded = false;
        }
    }

    private Lib() {
    }
}

