/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.glyph;

import alexthw.ars_scalaes.datagen.ArsProviders;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.sammy.malum.registry.common.DamageTypeRegistry;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectSoulShatter
extends AbstractEffect
implements IDamageEffect {
    public static final EffectSoulShatter INSTANCE = new EffectSoulShatter();

    public EffectSoulShatter() {
        super(ArsProviders.prefix("glyph_soul_shatter"), "Soul Shatter");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!(rayTraceResult.m_82443_() instanceof ItemEntity)) {
            double damage = (Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
            this.attemptDamage(world, shooter, spellStats, spellContext, resolver, rayTraceResult.m_82443_(), this.buildDamageSource(world, shooter), (float)damage);
        }
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        return DamageUtil.source((LevelAccessor)world, (ResourceKey)DamageTypeRegistry.VOODOO, (Entity)shooter);
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 5.0);
        this.addAmpConfig(builder, 3.0);
    }

    public int getDefaultManaCost() {
        return 30;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE});
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }
}

