/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.glyph;

import alexthw.ars_scalaes.datagen.ArsProviders;
import alexthw.ars_scalaes.identity.MorphingAbstraction;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectMorph
extends AbstractEffect
implements IPotionEffect {
    public static final EffectMorph INSTANCE = new EffectMorph();
    public ForgeConfigSpec.BooleanValue isTimeLimited;

    public EffectMorph() {
        super(ArsProviders.prefix("glyph_morph"), "Morph Identity");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (shooter instanceof ServerPlayer) {
            Entity entity;
            ServerPlayer player = (ServerPlayer)shooter;
            if (this.isRealPlayer((Entity)shooter) && (entity = rayTraceResult.m_82443_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (living instanceof FamiliarEntity) {
                    return;
                }
                if (living == shooter) {
                    MorphingAbstraction.morphInto(world, player, null);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123755_, shooter.m_20185_(), shooter.m_20186_() + 0.5, shooter.m_20189_(), 30, ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), 0.3);
                    return;
                }
                if (!(living instanceof Player) && living.m_21233_() < (float)((Integer)this.GENERIC_INT.get()).intValue()) {
                    MorphingAbstraction.morphInto(world, player, living);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123755_, shooter.m_20185_(), shooter.m_20186_() + 0.5, shooter.m_20189_(), 30, ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), 0.3);
                    if (((Boolean)EffectMorph.INSTANCE.isTimeLimited.get()).booleanValue()) {
                        INSTANCE.applyConfigPotion(living, (MobEffect)MorphingAbstraction.MORPH.get(), spellStats, false);
                    }
                }
            }
        }
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.isTimeLimited = builder.comment("Enable a timer on the resize effects. Caster will return to original self when potion effect is removed.").define("limitedMorphTime", false);
        this.addPotionConfig(builder, 120);
        this.addExtendTimeConfig(builder, 60);
        this.GENERIC_INT = builder.comment("Morph will only allow you to transform is the target have less maximum hp than this value.").defineInRange("max_hp_morph", 100, 20, Integer.MAX_VALUE);
    }

    public int getDefaultManaCost() {
        return 200;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.getSummonAugments();
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

