/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.block;

import alexthw.ars_scalaes.registry.ModRegistry;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DecoBlockPack {
    final DeferredRegister<Block> registry;
    public final String basename;
    final BlockBehaviour.Properties props;
    final Supplier<Block> full;
    final RegistryObject<Block> slab;
    final RegistryObject<Block> stair;
    RegistryObject<Block> wall = null;
    RegistryObject<Block> fence = null;
    RegistryObject<Block> fence_gate = null;

    public DecoBlockPack(DeferredRegister<Block> blocks, String basename, BlockBehaviour.Properties props) {
        this.registry = blocks;
        this.basename = basename;
        this.props = props;
        this.full = () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ars_nouveau", basename));
        this.slab = ModRegistry.addBlock(basename + "_slab", () -> new SlabBlock(props));
        this.stair = ModRegistry.addBlock(basename + "_stairs", () -> new StairBlock(() -> this.full.get().m_49966_(), props));
    }

    public DecoBlockPack addWall() {
        this.wall = ModRegistry.addBlock(this.basename + "_wall", () -> new WallBlock(this.props));
        return this;
    }

    public DecoBlockPack addFence(WoodType type) {
        this.fence = ModRegistry.addBlock(this.basename + "_fence", () -> new FenceBlock(this.props));
        this.fence_gate = ModRegistry.addBlock(this.basename + "_fence_gate", () -> new FenceGateBlock(this.props, type));
        return this;
    }

    public Block getBlock() {
        return this.full.get();
    }

    public Block getSlab() {
        return (Block)this.slab.get();
    }

    public Block getStairs() {
        return (Block)this.stair.get();
    }

    public Block getWall() {
        return (Block)this.wall.get();
    }

    public Block getFence() {
        return (Block)this.fence.get();
    }

    public Block getFenceGate() {
        return (Block)this.fence_gate.get();
    }
}

