/*
 * Decompiled with CFR 0.152.
 */
package rainbows.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import rainbows.config.Config;
import rainbows.util.RHelpers;
import rainbows.util.RainbowsData;

@OnlyIn(value=Dist.CLIENT)
public class RainbowsRenderer {
    public static final ResourceLocation RAINBOW_TILE = RHelpers.identifier("textures/environment/tile.png");
    public double rainbowDoubleTick;
    public double rainbowTick;
    public static long oldGameTime;
    public float oldRainLevel;
    public static final double BRIGHTNESS_MIN_VALUE = 0.0;
    public static final double BRIGHTNESS_MAX_VALUE = 1.0;
    public static final double BRIGHTNESS_DELTA_INCREMENT = 1.0E-4;
    public double currentBrightnessValue = 0.0;
    public double deltaBrightness = 0.0;

    public void render(RainbowsData data, Minecraft minecraft, Level level, PoseStack poseStack, Matrix4f matrix, float partialTicks) {
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || level == null) {
            return;
        }
        this.checkBiome(data, (Player)player, level);
        int startTick = 4000;
        float rainLevel = level.m_46722_(partialTicks);
        float time = level.m_46942_(partialTicks);
        double brightness = Mth.m_14008_((double)(Math.cos(Math.PI * 2 * (double)time) * 3.0), (double)0.0, (double)1.0) * this.deltaBrightness;
        if (rainLevel < 0.5f && this.oldRainLevel > rainLevel && brightness > 0.0 && this.rainbowTick <= 0.0) {
            this.rainbowTick = 4000.0;
        }
        if (this.rainbowTick > 0.0) {
            if (!(oldGameTime >= level.m_46467_() || minecraft.m_91090_() && minecraft.m_91104_())) {
                double isRainingAgainMod = rainLevel > 0.1f ? 50.0 * (double)rainLevel : 0.0;
                this.rainbowTick -= data.rainbowSpeed + isRainingAgainMod;
                this.rainbowDoubleTick += data.rainbowDoubleSpeed;
            }
            double alpha = Math.sin(Math.pow(this.rainbowTick * 4.430823548557134E-4, 2.0)) * brightness * data.rainbowAlpha;
            double distance = data.rainbowDistance;
            poseStack.m_85836_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-((Double)Config.COMMON.sunRotation.get()).floatValue()));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(time * 360.0f + 90.0f));
            poseStack.m_85837_(0.0, data.rainbowHeightOffset, distance);
            Matrix4f matrixTranslated = poseStack.m_85850_().m_252922_();
            double doubleRainbowAlpha = Mth.m_14008_((double)Math.pow(RHelpers.noise(this.rainbowDoubleTick, 1L, 2, 0, 1, 1.0), 1.25), (double)0.0, (double)1.0);
            this.renderRainbow(true, data, minecraft, (Player)player, level, poseStack, matrixTranslated, alpha, distance, data.rainbowWidthDeg, data.rainbowHeightDeg, data.rainbowThickness, 1.0);
            this.renderRainbow(false, data, minecraft, (Player)player, level, poseStack, matrixTranslated, alpha * data.rainbowDoubleAlpha * doubleRainbowAlpha, distance, data.rainbowDoubleWidthDeg, data.rainbowDoubleHeightDeg, data.rainbowDoubleThickness, 0.0);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            poseStack.m_85849_();
        }
        oldGameTime = level.m_46467_();
        this.oldRainLevel = rainLevel;
    }

    public void renderRainbow(boolean inner, RainbowsData data, Minecraft minecraft, Player player, Level level, PoseStack poseStack, Matrix4f matrix, double raininess, double distance, double radiusDegX, double radiusDegY, double thickness, double whiteAlphaFactor) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172811_);
        int detail = (Boolean)Config.COMMON.globalDetailOverride.get() != false ? (Integer)Config.COMMON.rainbowDetail.get() : data.rainbowDetail;
        double segments = Math.max((double)Math.round(minecraft.f_91066_.m_232060_().m_231551_() == GraphicsStatus.FAST ? (double)detail * 0.25 : (double)detail), 16.0);
        if (segments == 0.0) {
            return;
        }
        double bandSegments = ((Integer)Config.COMMON.rainbowColorDetail.get()).intValue();
        Color colorInner = RainbowsRenderer.getColor(data, 1.0);
        float rInner = (float)colorInner.getRed() / 255.0f;
        float gInner = (float)colorInner.getGreen() / 255.0f;
        float bInner = (float)colorInner.getBlue() / 255.0f;
        float aInner = (float)((double)((float)colorInner.getAlpha() / 255.0f) * raininess);
        double i0 = distance * Math.tan(Math.toRadians(radiusDegX));
        double o0 = distance * Math.tan(Math.toRadians(radiusDegX));
        double i1 = distance * Math.tan(Math.toRadians(radiusDegY));
        double o1 = distance * Math.tan(Math.toRadians(radiusDegY));
        float u = (float)(1.0 / (1.0 + bandSegments) * thickness);
        u = inner ? 1.0f - u : 1.0f + u;
        for (double l = 0.0; l < segments; l += 1.0) {
            double l0 = l / segments;
            double l1 = (l + 1.0) / segments;
            double angle0 = Math.PI * 2 * l0;
            double angle1 = Math.PI * 2 * l1;
            float x0 = (float)(Math.sin(angle0) * i0);
            float x1 = (float)(Math.sin(angle1) * o0);
            float y0 = (float)(Math.cos(angle0) * i1);
            float y1 = (float)(Math.cos(angle1) * o1);
            float[] coords = new float[]{x0, x1, y0, y1};
            for (double m = 0.0; m <= bandSegments; m += 1.0) {
                double m0 = m / bandSegments;
                Color color = RainbowsRenderer.brightenColor(RainbowsRenderer.getColor(data, m0), (int)(((Double)Config.COMMON.rainbowBrightnessIncreaseFactor.get()).floatValue() * 255.0f));
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                float a = (float)((double)((float)color.getAlpha() / 255.0f) * raininess);
                coords = this.renderRainbowBand(builder, poseStack, matrix, u, r, g, b, a, coords);
            }
            if (!inner) continue;
            coords = this.renderRainbowBand(builder, poseStack, matrix, 0.0f, rInner, gInner, bInner, aInner, coords);
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public float[] renderRainbowBand(BufferBuilder builder, PoseStack poseStack, Matrix4f matrix, float u, float r, float g, float b, float a, float[] coords) {
        poseStack.m_85836_();
        float alpha = Mth.m_14036_((float)a, (float)0.0f, (float)1.0f);
        float x0 = coords[0];
        float x1 = coords[1];
        float y0 = coords[2];
        float y1 = coords[3];
        builder.m_252986_(matrix, x0, y0, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        builder.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        builder.m_252986_(matrix, x1 *= u, y1 *= u, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        builder.m_252986_(matrix, x0 *= u, y0 *= u, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        poseStack.m_85849_();
        float[] newCoords = new float[]{x0, x1, y0, y1};
        return newCoords;
    }

    public static Color[] getColor(RainbowsData data) {
        Color[] colors = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, (float)data.alphaRed), new Color(1.0f, 0.5f, 0.0f, (float)data.alphaOrange), new Color(1.0f, 1.0f, 0.0f, (float)data.alphaYellow), new Color(0.0f, 1.0f, 0.0f, (float)data.alphaGreen), new Color(0.0f, 1.0f, 1.0f, (float)data.alphaCyan), new Color(0.0f, 0.0f, 1.0f, (float)data.alphaBlue), new Color(0.5f, 0.0f, 1.0f, (float)data.alphaViolet), new Color(1.0f, 1.0f, 1.0f, (float)data.alphaWhite)};
        return colors;
    }

    public static Color getColor(RainbowsData data, double value) {
        Color[] colors = RainbowsRenderer.getColor(data);
        if (value <= 0.0) {
            return colors[0];
        }
        if (value >= 1.0) {
            return colors[colors.length - 1];
        }
        double scaledValue = value * (double)(colors.length - 1);
        int index = (int)scaledValue;
        double fraction = scaledValue - (double)index;
        Color startColor = colors[index];
        Color endColor = colors[index + 1];
        float red = (float)((double)startColor.getRed() * (1.0 - fraction) + (double)endColor.getRed() * fraction);
        float green = (float)((double)startColor.getGreen() * (1.0 - fraction) + (double)endColor.getGreen() * fraction);
        float blue = (float)((double)startColor.getBlue() * (1.0 - fraction) + (double)endColor.getBlue() * fraction);
        float alpha = (float)((double)startColor.getAlpha() * (1.0 - fraction) + (double)endColor.getAlpha() * fraction);
        return new Color(red / 255.0f, green / 255.0f, blue / 255.0f, alpha / 255.0f);
    }

    public static Color brightenColor(Color color, int brightnessIncrease) {
        int red = Mth.m_14045_((int)(color.getRed() + brightnessIncrease), (int)0, (int)255);
        int green = Mth.m_14045_((int)(color.getGreen() + brightnessIncrease), (int)0, (int)255);
        int blue = Mth.m_14045_((int)(color.getBlue() + brightnessIncrease), (int)0, (int)255);
        return new Color(red, green, blue, color.getAlpha());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkBiome(RainbowsData data, Player player, Level level) {
        if (!data.allowedBiomes.isEmpty()) {
            ResourceKey biome = (ResourceKey)level.m_204166_(player.m_20183_()).m_203543_().get();
            if (biome == null) return;
            boolean validBiome = data.allowedBiomes.contains(level.m_9598_().m_255025_(Registries.f_256952_).m_255043_(biome).toString());
            if (validBiome && this.deltaBrightness < 1.0) {
                this.deltaBrightness = Math.min(1.0, this.deltaBrightness + 1.0E-4);
                return;
            } else {
                if (validBiome) return;
                if (!(this.deltaBrightness > 0.0)) return;
                this.deltaBrightness = Math.max(0.0, this.deltaBrightness - 1.0E-4);
            }
            return;
        } else {
            if (!data.allowedBiomes.isEmpty() || !(this.deltaBrightness < 1.0)) return;
            this.deltaBrightness = Math.min(1.0, this.deltaBrightness + 1.0E-4);
        }
    }
}

