/*
 * Decompiled with CFR 0.152.
 */
package rainbows.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import rainbows.Rainbows;
import rainbows.config.Config;
import rainbows.util.RHelpers;

public class RainbowsData {
    public static final String OVERWORLD = "overworld.json";
    public static final String AETHER = "aether.json";
    public static final String THE_END = "the_end.json";
    public static final String CURRENT_VERSION = RHelpers.getVersion().toString();
    public static final List<RainbowsData> DATA_CACHE = new ArrayList<RainbowsData>();
    public static final Map<String, Tuple<Long, RainbowsData>> LAST_MODIFIED_TIMES = new HashMap<String, Tuple<Long, RainbowsData>>();
    public static final String DEFAULT_VERSION = "0";
    public static final boolean DEFAULT_SHOULD_AUTO_UPDATE = true;
    public static final int DEFAULT_RAINBOW_DETAIL = 50;
    public static final double DEFAULT_RAINBOW_WIDTH_DEG = 42.0;
    public static final double DEFAULT_RAINBOW_HEIGHT_DEG = 42.0;
    public static final double DEFAULT_RAINBOW_DOUBLE_WIDTH_DEG = 52.0;
    public static final double DEFAULT_RAINBOW_DOUBLE_HEIGHT_DEG = 52.0;
    public static final double DEFAULT_RAINBOW_DOUBLE_THICKNESS = 0.075;
    public static final double DEFAULT_RAINBOW_DISTANCE = 150.0;
    public static final double DEFAULT_RAINBOW_HEIGHT_OFFSET = 0.0;
    public static final double DEFAULT_RAINBOW_ALPHA = 0.25;
    public static final double DEFAULT_RAINBOW_DOUBLE_ALPHA = 0.25;
    public static final double DEFAULT_RAINBOW_SPEED = 1.0;
    public static final double DEFAULT_RAINBOW_DOUBLE_SPEED = 0.01;
    public static final double DEFAULT_RAINBOW_THICKNESS = 0.15;
    public static final double DEFAULT_ALPHA_RED = 1.0;
    public static final double DEFAULT_ALPHA_ORANGE = 1.0;
    public static final double DEFAULT_ALPHA_YELLOW = 1.0;
    public static final double DEFAULT_ALPHA_GREEN = 1.0;
    public static final double DEFAULT_ALPHA_CYAN = 1.0;
    public static final double DEFAULT_ALPHA_BLUE = 1.0;
    public static final double DEFAULT_ALPHA_VIOLET = 1.0;
    public static final double DEFAULT_ALPHA_WHITE = 0.15;
    public String version;
    public boolean shouldAutoUpdate;
    public List<String> allowedDimensions;
    public List<String> allowedBiomes;
    public int rainbowDetail;
    public double rainbowWidthDeg;
    public double rainbowHeightDeg;
    public double rainbowDoubleWidthDeg;
    public double rainbowDoubleHeightDeg;
    public double rainbowDoubleThickness;
    public double rainbowDistance;
    public double rainbowHeightOffset;
    public double rainbowAlpha;
    public double rainbowDoubleAlpha;
    public double rainbowSpeed;
    public double rainbowDoubleSpeed;
    public double rainbowThickness;
    public double alphaRed;
    public double alphaOrange;
    public double alphaYellow;
    public double alphaGreen;
    public double alphaCyan;
    public double alphaBlue;
    public double alphaViolet;
    public double alphaWhite;

    public static void init(IEventBus bus) {
        bus.addListener(EventPriority.HIGHEST, RainbowsData::createConfigsOnSetup);
    }

    public static void createConfigsOnSetup(FMLCommonSetupEvent event) {
        RainbowsData.createConfigs();
    }

    public static void createConfigs() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        File subDir = new File(configPath.toString(), "rainbows");
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        if (subDir.isDirectory()) {
            String configSubDir = subDir.getPath();
            if (subDir.list().length > 0 && ((Boolean)Config.COMMON.globalShouldAutoUpdate.get()).booleanValue()) {
                for (File file : subDir.listFiles()) {
                    JsonObject jsonObject;
                    if (!file.isFile() || !file.getName().endsWith(".json") || (jsonObject = RainbowsData.readJsonFile(file.getPath())) == null) continue;
                    boolean isOld = RHelpers.compareVersions(RHelpers.getAsString(jsonObject, "version", DEFAULT_VERSION)) >= 1;
                    boolean shouldUpdate = RHelpers.getAsBoolean(jsonObject, "shouldAutoUpdate", true);
                    if (!shouldUpdate || !isOld) continue;
                    if (file.getName().equals(OVERWORLD)) {
                        RainbowsData.createOverworldConfig(configSubDir, file.getName());
                        continue;
                    }
                    if (file.getName().equals(AETHER)) {
                        RainbowsData.createAetherConfig(configSubDir, file.getName());
                        continue;
                    }
                    RainbowsData.updateConfigValues(file, configSubDir, jsonObject);
                }
            } else if (subDir.list().length <= 0) {
                RainbowsData.createOverworldConfig(configSubDir, OVERWORLD);
                RainbowsData.createAetherConfig(configSubDir, AETHER);
            }
        }
    }

    public boolean updateConfig(File configFile) {
        JsonObject data = RainbowsData.readJsonFile(configFile.getPath());
        if (data == null || !data.isJsonObject()) {
            return false;
        }
        this.version = RHelpers.getAsString(data, "version", DEFAULT_VERSION);
        this.shouldAutoUpdate = RHelpers.getAsBoolean(data, "shouldAutoUpdate", true);
        ArrayList<String> dimensions = new ArrayList<String>();
        if (data.getAsJsonArray("allowedDimensions") != null) {
            for (JsonElement element : data.getAsJsonArray("allowedDimensions")) {
                dimensions.add(element.getAsString());
            }
        }
        this.allowedDimensions = dimensions;
        ArrayList<String> biomes = new ArrayList<String>();
        if (data.getAsJsonArray("allowedBiomes") != null) {
            for (JsonElement element : data.getAsJsonArray("allowedBiomes")) {
                biomes.add(element.getAsString());
            }
        }
        this.allowedBiomes = biomes;
        this.rainbowDetail = RHelpers.getAsInt(data, "rainbowDetail", 50);
        this.rainbowWidthDeg = RHelpers.getAsDouble(data, "rainbowWidthDeg", 42.0);
        this.rainbowHeightDeg = RHelpers.getAsDouble(data, "rainbowHeightDeg", 42.0);
        this.rainbowDoubleWidthDeg = RHelpers.getAsDouble(data, "rainbowDoubleWidthDeg", 52.0);
        this.rainbowDoubleHeightDeg = RHelpers.getAsDouble(data, "rainbowDoubleHeightDeg", 52.0);
        this.rainbowDoubleThickness = RHelpers.getAsDouble(data, "rainbowDoubleThickness", 0.075);
        this.rainbowDistance = RHelpers.getAsDouble(data, "rainbowDistance", 150.0);
        this.rainbowHeightOffset = RHelpers.getAsDouble(data, "rainbowHeightOffset", 0.0);
        this.rainbowAlpha = RHelpers.getAsDouble(data, "rainbowAlpha", 0.25);
        this.rainbowDoubleAlpha = RHelpers.getAsDouble(data, "rainbowDoubleAlpha", 0.25);
        this.rainbowSpeed = RHelpers.getAsDouble(data, "rainbowSpeed", 1.0);
        this.rainbowDoubleSpeed = RHelpers.getAsDouble(data, "rainbowDoubleSpeed", 0.01);
        this.rainbowThickness = RHelpers.getAsDouble(data, "rainbowThickness", 0.15);
        this.alphaRed = RHelpers.getAsDouble(data, "alphaRed", 1.0);
        this.alphaOrange = RHelpers.getAsDouble(data, "alphaOrange", 1.0);
        this.alphaYellow = RHelpers.getAsDouble(data, "alphaYellow", 1.0);
        this.alphaGreen = RHelpers.getAsDouble(data, "alphaGreen", 1.0);
        this.alphaCyan = RHelpers.getAsDouble(data, "alphaCyan", 1.0);
        this.alphaBlue = RHelpers.getAsDouble(data, "alphaBlue", 1.0);
        this.alphaViolet = RHelpers.getAsDouble(data, "alphaViolet", 1.0);
        this.alphaWhite = RHelpers.getAsDouble(data, "alphaWhite", 0.15);
        return true;
    }

    public static List<RainbowsData> getDataList(Level level) {
        ArrayList<RainbowsData> dataList = new ArrayList<RainbowsData>();
        String dimension = level.m_46472_().m_135782_().toString();
        for (RainbowsData data : DATA_CACHE) {
            if (!data.allowedDimensions.contains(dimension)) continue;
            dataList.add(data);
        }
        return dataList;
    }

    public static void updateConfigs() {
        File subDir = RainbowsData.getSubDirPath().toFile();
        ArrayList<String> paths = new ArrayList<String>();
        if (subDir.exists() && subDir.isDirectory()) {
            for (File file : subDir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                String path = file.getPath();
                paths.add(path);
                if (!LAST_MODIFIED_TIMES.containsKey(path)) {
                    RainbowsData data = new RainbowsData();
                    if (!data.updateConfig(file)) continue;
                    DATA_CACHE.add(data);
                    LAST_MODIFIED_TIMES.put(path, (Tuple<Long, RainbowsData>)new Tuple((Object)file.lastModified(), (Object)data));
                    continue;
                }
                if (((Long)LAST_MODIFIED_TIMES.get(path).m_14418_()).longValue() == file.lastModified()) continue;
                LAST_MODIFIED_TIMES.get(path).m_145023_((Object)file.lastModified());
                boolean result = ((RainbowsData)LAST_MODIFIED_TIMES.get(path).m_14419_()).updateConfig(file);
                if (result) continue;
                Rainbows.LOGGER.warn("There was an error loading config: " + path);
            }
        }
        if (!paths.isEmpty()) {
            HashSet<String> keys = new HashSet<String>(LAST_MODIFIED_TIMES.keySet());
            ArrayList<RainbowsData> items = new ArrayList<RainbowsData>();
            for (String dataPath : keys) {
                if (paths.contains(dataPath)) continue;
                items.add((RainbowsData)LAST_MODIFIED_TIMES.get(dataPath).m_14419_());
                LAST_MODIFIED_TIMES.remove(dataPath);
            }
            if (!items.isEmpty()) {
                for (RainbowsData data : items) {
                    DATA_CACHE.remove(data);
                }
            }
        }
    }

    public static File readConfigs(String dimension) {
        File subDir = RainbowsData.getSubDirPath().toFile();
        if (subDir.exists() && subDir.isDirectory()) {
            for (File file : subDir.listFiles()) {
                JsonObject jsonObject;
                if (!file.isFile() || !file.getName().endsWith(".json") || (jsonObject = RainbowsData.readJsonFile(file.getPath())) == null) continue;
                JsonArray allowedDimensions = jsonObject.getAsJsonArray("allowedDimensions");
                ArrayList<String> dimensions = new ArrayList<String>();
                for (JsonElement element : allowedDimensions) {
                    dimensions.add(element.getAsString());
                }
                if (allowedDimensions == null || !dimensions.contains(dimension)) continue;
                return file;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject readJsonFile(String filePath) {
        try (FileReader reader = new FileReader(filePath);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (element == null) return null;
            if (!element.isJsonObject()) return null;
            JsonObject jsonObject = element.getAsJsonObject();
            return jsonObject;
        }
        catch (JsonSyntaxException | IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Path getSubDirPath() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        return new File(configPath.toString(), "rainbows").toPath();
    }

    public static void updateConfigValues(File file, String filePath, JsonObject inputJson) {
        JsonObject jsonObject = inputJson.deepCopy();
        if (!jsonObject.has("version") || !jsonObject.get("version").getAsString().equals(CURRENT_VERSION)) {
            jsonObject.addProperty("version", CURRENT_VERSION);
        }
        if (!jsonObject.has("rainbowDetail") || jsonObject.get("rainbowDetail").getAsDouble() != 50.0) {
            jsonObject.addProperty("rainbowDetail", (Number)50);
        }
        if (!jsonObject.has("rainbowWidthDeg") || jsonObject.get("rainbowWidthDeg").getAsDouble() != 42.0) {
            jsonObject.addProperty("rainbowWidthDeg", (Number)42.0);
        }
        if (!jsonObject.has("rainbowHeightDeg") || jsonObject.get("rainbowHeightDeg").getAsDouble() != 42.0) {
            jsonObject.addProperty("rainbowHeightDeg", (Number)42.0);
        }
        if (!jsonObject.has("rainbowDoubleWidthDeg") || jsonObject.get("rainbowDoubleWidthDeg").getAsDouble() != 52.0) {
            jsonObject.addProperty("rainbowDoubleWidthDeg", (Number)52.0);
        }
        if (!jsonObject.has("rainbowDoubleHeightDeg") || jsonObject.get("rainbowDoubleHeightDeg").getAsDouble() != 52.0) {
            jsonObject.addProperty("rainbowDoubleHeightDeg", (Number)52.0);
        }
        if (!jsonObject.has("rainbowDoubleThickness") || jsonObject.get("rainbowDoubleThickness").getAsDouble() != 0.075) {
            jsonObject.addProperty("rainbowDoubleThickness", (Number)0.075);
        }
        if (!jsonObject.has("rainbowDistance") || jsonObject.get("rainbowDistance").getAsDouble() != 150.0) {
            jsonObject.addProperty("rainbowDistance", (Number)150.0);
        }
        if (!jsonObject.has("rainbowHeightOffset") || jsonObject.get("rainbowHeightOffset").getAsDouble() != 0.0) {
            jsonObject.addProperty("rainbowHeightOffset", (Number)0.0);
        }
        if (!jsonObject.has("rainbowAlpha") || jsonObject.get("rainbowAlpha").getAsDouble() != 0.25) {
            jsonObject.addProperty("rainbowAlpha", (Number)0.25);
        }
        if (!jsonObject.has("rainbowDoubleAlpha") || jsonObject.get("rainbowDoubleAlpha").getAsDouble() != 0.25) {
            jsonObject.addProperty("rainbowDoubleAlpha", (Number)0.25);
        }
        if (!jsonObject.has("rainbowSpeed") || jsonObject.get("rainbowSpeed").getAsDouble() != 1.0) {
            jsonObject.addProperty("rainbowSpeed", (Number)1.0);
        }
        if (!jsonObject.has("rainbowDoubleSpeed") || jsonObject.get("rainbowDoubleSpeed").getAsDouble() != 0.01) {
            jsonObject.addProperty("rainbowDoubleSpeed", (Number)0.01);
        }
        if (!jsonObject.has("rainbowThickness") || jsonObject.get("rainbowThickness").getAsDouble() != 0.15) {
            jsonObject.addProperty("rainbowThickness", (Number)0.15);
        }
        if (!jsonObject.has("alphaRed") || jsonObject.get("alphaRed").getAsDouble() != 1.0) {
            jsonObject.addProperty("alphaRed", (Number)1.0);
        }
        if (!jsonObject.has("alphaOrange") || jsonObject.get("alphaOrange").getAsDouble() != 1.0) {
            jsonObject.addProperty("alphaOrange", (Number)1.0);
        }
        if (!jsonObject.has("alphaYellow") || jsonObject.get("alphaYellow").getAsDouble() != 1.0) {
            jsonObject.addProperty("alphaYellow", (Number)1.0);
        }
        if (!jsonObject.has("alphaGreen") || jsonObject.get("alphaGreen").getAsDouble() != 1.0) {
            jsonObject.addProperty("alphaGreen", (Number)1.0);
        }
        if (!jsonObject.has("alphaCyan") || jsonObject.get("alphaCyan").getAsDouble() != 1.0) {
            jsonObject.addProperty("alphaCyan", (Number)1.0);
        }
        if (!jsonObject.has("alphaBlue") || jsonObject.get("alphaBlue").getAsDouble() != 1.0) {
            jsonObject.addProperty("alphaBlue", (Number)1.0);
        }
        if (!jsonObject.has("alphaViolet") || jsonObject.get("alphaViolet").getAsDouble() != 1.0) {
            jsonObject.addProperty("alphaViolet", (Number)1.0);
        }
        if (!jsonObject.has("alphaWhite") || jsonObject.get("alphaWhite").getAsDouble() != 0.15) {
            jsonObject.addProperty("alphaWhite", (Number)0.15);
        }
        RainbowsData.createFile(jsonObject, filePath + File.separator + file.getName());
    }

    public static void createOverworldConfig(String filePath, String fileName) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", CURRENT_VERSION);
        jsonObject.addProperty("shouldAutoUpdate", Boolean.valueOf(true));
        JsonArray allowedDimensions = new JsonArray();
        allowedDimensions.add("minecraft:overworld");
        jsonObject.add("allowedDimensions", (JsonElement)allowedDimensions);
        jsonObject.add("allowedBiomes", (JsonElement)new JsonArray());
        jsonObject.addProperty("rainbowDetail", (Number)50);
        jsonObject.addProperty("rainbowWidthDeg", (Number)42.0);
        jsonObject.addProperty("rainbowHeightDeg", (Number)42.0);
        jsonObject.addProperty("rainbowDoubleWidthDeg", (Number)52.0);
        jsonObject.addProperty("rainbowDoubleHeightDeg", (Number)52.0);
        jsonObject.addProperty("rainbowDoubleThickness", (Number)0.075);
        jsonObject.addProperty("rainbowDistance", (Number)150.0);
        jsonObject.addProperty("rainbowHeightOffset", (Number)0.0);
        jsonObject.addProperty("rainbowAlpha", (Number)0.25);
        jsonObject.addProperty("rainbowDoubleAlpha", (Number)0.25);
        jsonObject.addProperty("rainbowSpeed", (Number)1.0);
        jsonObject.addProperty("rainbowDoubleSpeed", (Number)0.01);
        jsonObject.addProperty("rainbowThickness", (Number)0.15);
        jsonObject.addProperty("alphaRed", (Number)1.0);
        jsonObject.addProperty("alphaOrange", (Number)1.0);
        jsonObject.addProperty("alphaYellow", (Number)1.0);
        jsonObject.addProperty("alphaGreen", (Number)1.0);
        jsonObject.addProperty("alphaCyan", (Number)1.0);
        jsonObject.addProperty("alphaBlue", (Number)1.0);
        jsonObject.addProperty("alphaViolet", (Number)1.0);
        jsonObject.addProperty("alphaWhite", (Number)0.15);
        RainbowsData.createFile(jsonObject, filePath + File.separator + fileName);
    }

    public static void createAetherConfig(String filePath, String fileName) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", CURRENT_VERSION);
        jsonObject.addProperty("shouldAutoUpdate", Boolean.valueOf(true));
        JsonArray allowedDimensions = new JsonArray();
        allowedDimensions.add("aether:the_aether");
        jsonObject.add("allowedDimensions", (JsonElement)allowedDimensions);
        jsonObject.add("allowedBiomes", (JsonElement)new JsonArray());
        jsonObject.addProperty("rainbowDetail", (Number)50);
        jsonObject.addProperty("rainbowWidthDeg", (Number)42.0);
        jsonObject.addProperty("rainbowHeightDeg", (Number)42.0);
        jsonObject.addProperty("rainbowDoubleWidthDeg", (Number)52.0);
        jsonObject.addProperty("rainbowDoubleHeightDeg", (Number)52.0);
        jsonObject.addProperty("rainbowDoubleThickness", (Number)0.075);
        jsonObject.addProperty("rainbowDistance", (Number)150.0);
        jsonObject.addProperty("rainbowHeightOffset", (Number)0.0);
        jsonObject.addProperty("rainbowAlpha", (Number)0.25);
        jsonObject.addProperty("rainbowDoubleAlpha", (Number)0.25);
        jsonObject.addProperty("rainbowSpeed", (Number)1.0);
        jsonObject.addProperty("rainbowDoubleSpeed", (Number)0.01);
        jsonObject.addProperty("rainbowThickness", (Number)0.15);
        jsonObject.addProperty("alphaRed", (Number)1.0);
        jsonObject.addProperty("alphaOrange", (Number)1.0);
        jsonObject.addProperty("alphaYellow", (Number)1.0);
        jsonObject.addProperty("alphaGreen", (Number)1.0);
        jsonObject.addProperty("alphaCyan", (Number)1.0);
        jsonObject.addProperty("alphaBlue", (Number)1.0);
        jsonObject.addProperty("alphaViolet", (Number)1.0);
        jsonObject.addProperty("alphaWhite", (Number)0.15);
        RainbowsData.createFile(jsonObject, filePath + File.separator + fileName);
    }

    public static void createFile(JsonObject jsonObject, String fileName) {
        try (FileWriter file = new FileWriter(fileName);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String pretty = gson.toJson((JsonElement)jsonObject);
            file.write(pretty);
            file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

