/*
 * Decompiled with CFR 0.152.
 */
package rainbows.util;

import java.util.function.DoubleUnaryOperator;
import net.minecraft.util.Mth;
import rainbows.util.FastNoiseLite;
import rainbows.util.OpenSimplex2D;

@FunctionalInterface
public interface Noise2D {
    public double noise(double var1, double var3);

    default public Noise2D octaves(int octaves) {
        double[] frequency = new double[octaves];
        double[] amplitude = new double[octaves];
        for (int i = 0; i < octaves; ++i) {
            frequency[i] = 1 << i;
            amplitude[i] = Math.pow(0.5, octaves - i);
        }
        return (x, y) -> {
            double value = 0.0;
            for (int i = 0; i < octaves; ++i) {
                value += this.noise(x / frequency[i], y / frequency[i]) * amplitude[i];
            }
            return value;
        };
    }

    default public Noise2D ridged() {
        return (x, y) -> {
            double value = this.noise(x, y);
            value = value < 0.0 ? -value : value;
            return 1.0 - 2.0 * value;
        };
    }

    default public Noise2D abs() {
        return (x, y) -> Math.abs(this.noise(x, y));
    }

    default public Noise2D terraces(int levels) {
        return (x, y) -> {
            double value = 0.5 * this.noise(x, y) + 0.5;
            double rounded = (int)(value * (double)levels);
            return rounded * 2.0 / (double)levels - 1.0;
        };
    }

    default public Noise2D spread(double scaleFactor) {
        return (x, y) -> this.noise(x * scaleFactor, y * scaleFactor);
    }

    default public Noise2D scaled(double min, double max) {
        return this.scaled(-1.0, 1.0, min, max);
    }

    default public Noise2D scaled(double oldMin, double oldMax, double min, double max) {
        double scale = (max - min) / (oldMax - oldMin);
        double shift = min - oldMin * scale;
        return this.affine(scale, shift);
    }

    default public Noise2D affine(double scale, double shift) {
        return (x, y) -> this.noise(x, y) * scale + shift;
    }

    default public Noise2D warped(OpenSimplex2D warp) {
        warp.fnl.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
        warp.fnl.SetFractalType(FastNoiseLite.FractalType.DomainWarpIndependent);
        warp.fnl.SetDomainWarpAmp(warp.getAmplitude() * 2.0);
        FastNoiseLite.Vector2 cursor = new FastNoiseLite.Vector2(0.0, 0.0);
        return (x, z) -> {
            cursor.x = x;
            cursor.y = z;
            warp.fnl.DomainWarp(cursor);
            return this.noise(cursor.x, cursor.y);
        };
    }

    default public Noise2D clamped(double min, double max) {
        return (x, y) -> Mth.m_14008_((double)this.noise(x, y), (double)min, (double)max);
    }

    default public Noise2D add(Noise2D other) {
        return (x, y) -> this.noise(x, y) + other.noise(x, y);
    }

    default public Noise2D lazyProduct(Noise2D other) {
        return (x, y) -> {
            double value = this.noise(x, y);
            return value == 0.0 ? 0.0 : value * other.noise(x, y);
        };
    }

    default public Noise2D map(DoubleUnaryOperator mappingFunction) {
        return (x, y) -> mappingFunction.applyAsDouble(this.noise(x, y));
    }
}

