/*
 * Decompiled with CFR 0.152.
 */
package rainbows.config;

import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config COMMON = Config.register(ModConfig.Type.COMMON, Config::new);
    public final ForgeConfigSpec.BooleanValue globalDetailOverride;
    public final ForgeConfigSpec.BooleanValue globalShouldAutoUpdate;
    public final ForgeConfigSpec.IntValue rainbowDetail;
    public final ForgeConfigSpec.IntValue rainbowColorDetail;
    public final ForgeConfigSpec.DoubleValue rainbowBrightnessIncreaseFactor;
    public final ForgeConfigSpec.DoubleValue sunRotation;

    public static void init() {
    }

    private static <C> C register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, C> factory) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(factory);
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)specPair.getRight());
        return (C)specPair.getLeft();
    }

    Config(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("rainbows.config.common." + name);
        innerBuilder.push("General");
        this.globalDetailOverride = builder.apply("globalDetailOverride").comment("Global toggle for controlling rainbow detail.").define("globalDetailOverride", false);
        this.globalShouldAutoUpdate = builder.apply("globalShouldAutoUpdate").comment("If set to true, then the configs will update every mod update. Set to false if you want to manage config changes yourself.").define("globalShouldAutoUpdate", true);
        this.rainbowDetail = builder.apply("rainbowDetail").comment("How high of a resolution should the rainbow render in? Lower value = lower resolution and quality but more FPS.").defineInRange("rainbowDetail", 150, 0, Integer.MAX_VALUE);
        this.rainbowColorDetail = builder.apply("rainbowColorDetail").comment("How high of a fidelity should the rainbow gradient layers have? Lower value = less gradient layers but more FPS.").defineInRange("rainbowColorDetail", 32, 1, Integer.MAX_VALUE);
        this.rainbowBrightnessIncreaseFactor = builder.apply("rainbowBrightnessIncreaseFactor").comment("Brightness multiplier value added to the colors of the rainbow. 0 = no change, 1 = fully white.").defineInRange("rainbowBrightnessIncreaseFactor", 0.25, 0.0, 1.0);
        this.sunRotation = builder.apply("sunRotation").comment("Sun rotation.").defineInRange("sunRotation", 39.0, -360.0, 360.0);
        innerBuilder.pop();
    }
}

