/*
 * Decompiled with CFR 0.152.
 */
package rainbows.client;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import rainbows.client.ParticleRegistry;
import rainbows.util.RHelpers;
import rainbows.util.RainbowsData;
import rainbows.util.RainbowsRendererParticle;

public class ClientEventHandler {
    public static final ConcurrentMap<ResourceKey<Level>, RainbowsRendererParticle> HAS_RAINBOW = new ConcurrentHashMap<ResourceKey<Level>, RainbowsRendererParticle>();

    public static void init() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus bus = MinecraftForge.EVENT_BUS;
        modBus.addListener(ClientEventHandler::registerKeyBindings);
        modBus.addListener(ParticleRegistry::registerParticles);
        bus.addListener(ClientEventHandler::onKeyEvent);
        bus.addListener(ClientEventHandler::onWorldLoad);
        bus.addListener(ClientEventHandler::handleRainbow);
        bus.addListener(ClientEventHandler::onWorldUnload);
    }

    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(RHelpers.RELOAD_RAINBOW_CONFIGS);
    }

    public static void onKeyEvent(InputEvent.Key event) {
        if (RHelpers.RELOAD_RAINBOW_CONFIGS.m_90857_()) {
            RainbowsData.createConfigs();
            RainbowsData.updateConfigs();
        }
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        RainbowsData.createConfigs();
        RainbowsData.updateConfigs();
        HAS_RAINBOW.clear();
    }

    public static void onWorldUnload(LevelEvent.Unload event) {
        HAS_RAINBOW.clear();
    }

    public static void handleRainbow(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null) {
            LocalPlayer player = minecraft.f_91074_;
            ClientLevel level = minecraft.f_91073_;
            if (player != null && level != null) {
                for (RainbowsData data : RainbowsData.getDataList((Level)level)) {
                    if (data == null) continue;
                    for (String dimension : data.allowedDimensions) {
                        ResourceKey dimensionKey;
                        if (!dimension.equals((dimensionKey = level.m_46472_()).m_135782_().toString()) || HAS_RAINBOW.containsKey(dimensionKey)) continue;
                        RainbowsRendererParticle rainbowParticle = new RainbowsRendererParticle(level, player.m_20182_(), (Player)player, data, (ResourceKey<Level>)dimensionKey);
                        minecraft.f_91061_.m_107344_((Particle)rainbowParticle);
                        HAS_RAINBOW.put((ResourceKey<Level>)dimensionKey, rainbowParticle);
                    }
                }
            }
        }
    }
}

