/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.icetower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.icetower.IceTowerBridgeComponent;
import twilightforest.world.components.structures.icetower.IceTowerDecorator;
import twilightforest.world.components.structures.icetower.IceTowerEntranceComponent;
import twilightforest.world.components.structures.icetower.IceTowerWingComponent;

public class IceTowerMainComponent
extends IceTowerWingComponent {
    public boolean hasBossWing = false;

    public IceTowerMainComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFITMai.get(), nbt);
        this.hasBossWing = nbt.m_128471_("hasBossWing");
    }

    public IceTowerMainComponent(RandomSource rand, int index, int x, int y, int z) {
        this(rand, index, x + 11, y + 40, z + 11, Direction.NORTH);
    }

    public IceTowerMainComponent(RandomSource rand, int index, int x, int y, int z, Direction rotation) {
        super((StructurePieceType)TFStructurePieceTypes.TFITMai.get(), index, x, y, z, 11, 31 + rand.m_188503_(3) * 10, rotation);
        if (this.deco == null) {
            this.deco = new IceTowerDecorator();
        }
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128379_("hasBossWing", this.hasBossWing);
    }

    @Override
    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        int length;
        super.m_214092_(parent, list, rand);
        BoundingBox towerBB = BoundingBoxUtils.clone(this.f_73383_);
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            for (StructurePiece structurecomponent : start.f_192778_) {
                towerBB.m_162386_(structurecomponent.m_73547_());
            }
        }
        BlockPos myDoor = (BlockPos)this.openings.get(0);
        BlockPos entranceDoor = new BlockPos((Vec3i)myDoor);
        if (myDoor.m_123341_() == 0 && (length = this.m_73547_().m_162395_() - towerBB.m_162395_()) >= 0) {
            entranceDoor = entranceDoor.m_122025_(length);
            this.makeEntranceBridge(list, rand, this.m_73548_() + 1, myDoor.m_123341_(), myDoor.m_123342_(), myDoor.m_123343_(), length, Rotation.CLOCKWISE_180);
        }
        if (myDoor.m_123341_() == this.size - 1) {
            entranceDoor = entranceDoor.m_122030_(towerBB.m_162399_() - this.m_73547_().m_162399_());
        }
        if (myDoor.m_123343_() == 0) {
            entranceDoor = entranceDoor.m_122020_(towerBB.m_162398_() - this.m_73547_().m_162398_());
        }
        if (myDoor.m_123341_() == this.size - 1) {
            entranceDoor = entranceDoor.m_122020_(towerBB.m_162401_() - this.m_73547_().m_162401_());
        }
        this.makeEntranceTower(list, rand, this.m_73548_() + 1, entranceDoor.m_123341_(), entranceDoor.m_123342_(), entranceDoor.m_123343_(), 11, 11, this.f_73379_);
    }

    private void makeEntranceBridge(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int length, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        BlockPos dest = this.offsetTowerCCoords(x, y, z, 5, direction);
        IceTowerBridgeComponent bridge = new IceTowerBridgeComponent(index, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), length, direction);
        list.m_142679_((StructurePiece)bridge);
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            bridge.m_214092_((StructurePiece)start.f_192778_.get(0), list, rand);
        }
    }

    public boolean makeEntranceTower(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        IceTowerEntranceComponent entrance = new IceTowerEntranceComponent(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.m_142679_((StructurePiece)entrance);
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            ((IceTowerWingComponent)entrance).m_214092_((StructurePiece)start.f_192778_.get(0), list, rand);
        }
        this.addOpening(x, y, z, rotation);
        return true;
    }
}

