/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import twilightforest.entity.passive.QuestRam;

public class QuestRamModel
extends HierarchicalModel<QuestRam> {
    public final ModelPart root;
    final ModelPart rearbody;
    public final ModelPart leg1;
    public final ModelPart haunch1;
    public final ModelPart leg2;
    public final ModelPart haunch2;
    public final ModelPart leg3;
    public final ModelPart haunch3;
    public final ModelPart leg4;
    public final ModelPart haunch4;
    public final ModelPart neck;
    public final ModelPart head;
    public final ModelPart[] segments = new ModelPart[16];
    final int[] colorOrder = new int[]{0, 8, 7, 15, 14, 1, 4, 5, 13, 3, 9, 11, 10, 2, 6, 12};

    public QuestRamModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.neck = root.m_171324_("neck");
        this.rearbody = root.m_171324_("rear_body");
        this.haunch1 = root.m_171324_("right_front_haunch");
        this.leg1 = root.m_171324_("right_front_leg");
        this.haunch2 = root.m_171324_("left_front_haunch");
        this.leg2 = root.m_171324_("left_front_leg");
        this.haunch3 = root.m_171324_("right_back_haunch");
        this.leg3 = root.m_171324_("right_back_leg");
        this.haunch4 = root.m_171324_("left_back_haunch");
        this.leg4 = root.m_171324_("left_back_leg");
        Arrays.setAll(this.segments, num -> root.m_171324_(QuestRamModel.getSegmentName(num)));
        for (int i = 0; i < 16; ++i) {
            this.segments[i].f_104207_ = false;
        }
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition base = mesh.m_171576_();
        PartDefinition headpart = base.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 70).m_171481_(-6.0f, -4.5f, -15.0f, 12.0f, 9.0f, 15.0f).m_171514_(0, 94).m_171481_(5.0f, -9.0f, -7.0f, 4.0f, 4.0f, 6.0f).m_171514_(20, 96).m_171481_(7.0f, -8.0f, -2.0f, 3.0f, 4.0f, 4.0f).m_171514_(34, 95).m_171481_(8.0f, -6.0f, 0.0f, 3.0f, 6.0f, 3.0f).m_171514_(46, 98).m_171481_(9.5f, -2.0f, -2.0f, 3.0f, 3.0f, 3.0f).m_171514_(58, 95).m_171481_(11.0f, 0.0f, -7.0f, 3.0f, 3.0f, 6.0f).m_171514_(76, 95).m_171481_(12.0f, -4.0f, -9.0f, 3.0f, 6.0f, 3.0f).m_171514_(88, 97).m_171481_(13.0f, -6.0f, -7.0f, 3.0f, 3.0f, 4.0f).m_171514_(0, 94).m_171481_(-9.0f, -9.0f, -7.0f, 4.0f, 4.0f, 6.0f).m_171514_(20, 96).m_171481_(-10.0f, -8.0f, -2.0f, 3.0f, 4.0f, 4.0f).m_171514_(34, 95).m_171481_(-11.0f, -6.0f, 0.0f, 3.0f, 6.0f, 3.0f).m_171514_(46, 98).m_171481_(-12.5f, -2.0f, -2.0f, 3.0f, 3.0f, 3.0f).m_171514_(58, 95).m_171481_(-14.0f, 0.0f, -7.0f, 3.0f, 3.0f, 6.0f).m_171514_(76, 95).m_171481_(-15.0f, -4.0f, -9.0f, 3.0f, 6.0f, 3.0f).m_171514_(88, 97).m_171481_(-16.0f, -6.0f, -7.0f, 3.0f, 3.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)-5.0f));
        headpart.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(54, 73).m_171481_(-5.5f, -5.0f, -13.0f, 11.0f, 9.0f, 12.0f), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)-1.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        base.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(66, 37).m_171481_(-5.5f, -8.0f, -8.0f, 11.0f, 14.0f, 12.0f), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)-7.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        base.m_171599_("front_body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-9.0f, -7.5f, -15.0f, 18.0f, 15.0f, 15.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)2.0f));
        base.m_171599_("rear_body", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-9.0f, -7.5f, 0.0f, 18.0f, 15.0f, 15.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)4.0f));
        base.m_171599_("right_front_haunch", CubeListBuilder.m_171558_().m_171514_(90, 0).m_171481_(-3.5f, 0.0f, -6.0f, 7.0f, 10.0f, 10.0f), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)13.0f));
        base.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171481_(-3.0f, 10.0f, -3.0f, 6.0f, 12.0f, 6.0f), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)13.0f));
        base.m_171599_("left_front_haunch", CubeListBuilder.m_171558_().m_171514_(90, 0).m_171481_(-3.5f, 0.0f, -6.0f, 7.0f, 10.0f, 10.0f), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)13.0f));
        base.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171481_(-3.0f, 10.0f, -3.0f, 6.0f, 12.0f, 6.0f), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)13.0f));
        base.m_171599_("right_back_haunch", CubeListBuilder.m_171558_().m_171514_(90, 20).m_171481_(-3.5f, 0.0f, -4.0f, 7.0f, 10.0f, 7.0f), PartPose.m_171419_((float)-6.0f, (float)1.0f, (float)-8.0f));
        base.m_171599_("right_back_leg", CubeListBuilder.m_171558_().m_171514_(66, 18).m_171481_(-3.0f, 10.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)-6.0f, (float)1.0f, (float)-8.0f));
        base.m_171599_("left_back_haunch", CubeListBuilder.m_171558_().m_171514_(90, 20).m_171481_(-3.5f, 0.0f, -4.0f, 7.0f, 10.0f, 7.0f), PartPose.m_171419_((float)6.0f, (float)1.0f, (float)-8.0f));
        base.m_171599_("left_back_leg", CubeListBuilder.m_171558_().m_171514_(66, 18).m_171481_(-3.0f, 10.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)6.0f, (float)1.0f, (float)-8.0f));
        CubeListBuilder bodycube = CubeListBuilder.m_171558_().m_171514_(0, 104).m_171481_(-9.0f, -7.5f, 0.0f, 18.0f, 15.0f, 2.0f);
        for (int i = 0; i < 16; ++i) {
            base.m_171599_(QuestRamModel.getSegmentName(i), bodycube, PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)2.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    private static String getSegmentName(int num) {
        return "segment" + num;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int light, int overlay, float red, float green, float blue, float alpha) {
        super.m_7695_(stack, builder, light, overlay, red, green, blue, alpha);
        for (int i = 0; i < 16; ++i) {
            float[] dyeRgb = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)i));
            this.segments[i].m_104306_(stack, builder, light, overlay, dyeRgb[0], dyeRgb[1], dyeRgb[2], alpha);
        }
    }

    public void setupAnim(QuestRam entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch / 57.295776f;
        this.neck.f_104204_ = this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.leg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leg2.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.leg3.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.leg4.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.haunch1.f_104203_ = this.leg1.f_104203_;
        this.haunch2.f_104203_ = this.leg2.f_104203_;
        this.haunch3.f_104203_ = this.leg3.f_104203_;
        this.haunch4.f_104203_ = this.leg4.f_104203_;
    }

    public void prepareMobModel(QuestRam entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        int count = entity.countColorsSet();
        this.rearbody.f_104202_ = 2 + 2 * count;
        this.leg1.f_104202_ = 11 + 2 * count;
        this.leg2.f_104202_ = 11 + 2 * count;
        this.haunch1.f_104202_ = 11 + 2 * count;
        this.haunch2.f_104202_ = 11 + 2 * count;
        int segmentOffset = 2;
        for (int color : this.colorOrder) {
            if (entity.isColorPresent(DyeColor.m_41053_((int)color))) {
                this.segments[color].f_104207_ = true;
                this.segments[color].f_104202_ = segmentOffset;
                segmentOffset += 2;
                continue;
            }
            this.segments[color].f_104207_ = false;
        }
    }
}

