/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ConnectableRotatedPillarBlock
extends RotatedPillarBlock {
    protected static final BooleanProperty NORTH = PipeBlock.f_55148_;
    protected static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    protected static final BooleanProperty WEST = PipeBlock.f_55151_;
    protected static final BooleanProperty EAST = PipeBlock.f_55149_;
    protected static final BooleanProperty UP = PipeBlock.f_55152_;
    protected static final BooleanProperty DOWN = PipeBlock.f_55153_;
    final double boundingBoxWidthLower;
    final double boundingBoxWidthUpper;

    ConnectableRotatedPillarBlock(BlockBehaviour.Properties props, double size) {
        this(props, size, size);
    }

    ConnectableRotatedPillarBlock(BlockBehaviour.Properties props, double width, double height) {
        super(props.m_60955_());
        if (width >= 16.0) {
            this.boundingBoxWidthLower = 0.0;
            this.boundingBoxWidthUpper = 16.0;
        } else {
            this.boundingBoxWidthLower = 8.0 - width / 2.0;
            this.boundingBoxWidthUpper = 16.0 - this.boundingBoxWidthLower;
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, DOWN, UP});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos pos, BlockPos facingPos) {
        return (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(facing), (Comparable)Boolean.valueOf(this.canConnectTo((Direction.Axis)state.m_61143_((Property)f_55923_), facing, facingState, facingState.m_60783_((BlockGetter)accessor, facingPos, facing.m_122424_()))));
    }

    public boolean canConnectTo(Direction.Axis thisAxis, Direction facing, BlockState facingState, boolean solidSide) {
        return !ConnectableRotatedPillarBlock.m_152463_((BlockState)facingState) && solidSide;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122019_();
        BlockPos blockpos3 = blockpos.m_122024_();
        BlockPos blockpos4 = blockpos.m_122029_();
        BlockState blockstate = iblockreader.m_8055_(blockpos1);
        BlockState blockstate1 = iblockreader.m_8055_(blockpos2);
        BlockState blockstate2 = iblockreader.m_8055_(blockpos3);
        BlockState blockstate3 = iblockreader.m_8055_(blockpos4);
        Direction.Axis axis = context.m_43719_().m_122434_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)axis)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(axis, Direction.NORTH, blockstate, blockstate.m_60783_((BlockGetter)iblockreader, blockpos1, Direction.SOUTH))))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(axis, Direction.SOUTH, blockstate1, blockstate1.m_60783_((BlockGetter)iblockreader, blockpos2, Direction.NORTH))))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(axis, Direction.WEST, blockstate2, blockstate2.m_60783_((BlockGetter)iblockreader, blockpos3, Direction.EAST))))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(axis, Direction.EAST, blockstate3, blockstate3.m_60783_((BlockGetter)iblockreader, blockpos4, Direction.WEST))));
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_((Property)f_55923_)) {
            case Direction.Axis.X -> ConnectableRotatedPillarBlock.m_49796_((double)0.0, (double)((Boolean)state.m_61143_((Property)NORTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.m_61143_((Property)WEST) != false ? 0.0 : this.boundingBoxWidthLower), (double)16.0, (double)((Boolean)state.m_61143_((Property)SOUTH) != false ? 16.0 : this.boundingBoxWidthUpper), (double)((Boolean)state.m_61143_((Property)EAST) != false ? 16.0 : this.boundingBoxWidthUpper));
            case Direction.Axis.Z -> ConnectableRotatedPillarBlock.m_49796_((double)((Boolean)state.m_61143_((Property)EAST) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.m_61143_((Property)SOUTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)0.0, (double)((Boolean)state.m_61143_((Property)WEST) != false ? 16.0 : this.boundingBoxWidthUpper), (double)((Boolean)state.m_61143_((Property)NORTH) != false ? 16.0 : this.boundingBoxWidthUpper), (double)16.0);
            default -> ConnectableRotatedPillarBlock.m_49796_((double)((Boolean)state.m_61143_((Property)WEST) != false ? 0.0 : this.boundingBoxWidthLower), (double)0.0, (double)((Boolean)state.m_61143_((Property)NORTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.m_61143_((Property)EAST) != false ? 16.0 : this.boundingBoxWidthUpper), (double)16.0, (double)((Boolean)state.m_61143_((Property)SOUTH) != false ? 16.0 : this.boundingBoxWidthUpper));
        };
    }
}

