/*
 * Decompiled with CFR 0.152.
 */
package io.github.derringersmods.toomanyglyphs.common.network;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import io.github.derringersmods.toomanyglyphs.common.network.AbstractPacketHandler;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class NetworkUtil {
    public static ConcurrentHashMap<Class, AbstractPacketHandler> clientHandlers = new ConcurrentHashMap();

    public static <MSG> AbstractPacketHandler<MSG> getClientHandlerFor(Class<MSG> packetType) {
        return clientHandlers.computeIfAbsent(packetType, t -> {
            try {
                return (AbstractPacketHandler)Class.forName(t.getTypeName() + "$ClientHandler").newInstance();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return NullPacketHandler.INSTANCE;
            }
        });
    }

    public static void encode(@Nonnull FriendlyByteBuf buf, @Nonnull Vec3 item) {
        buf.writeDouble(item.f_82479_);
        buf.writeDouble(item.f_82480_);
        buf.writeDouble(item.f_82481_);
    }

    @Nonnull
    public static Vec3 decodeVector3d(@Nonnull FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vec3(x, y, z);
    }

    public static void encode(@Nonnull FriendlyByteBuf buf, @Nonnull ParticleColor item) {
        buf.writeInt(item.getColor());
    }

    @Nonnull
    public static ParticleColor decodeParticleColor(@Nonnull FriendlyByteBuf buf) {
        int rgb = buf.readInt();
        return ParticleColor.fromInt((int)rgb);
    }

    public static class NullPacketHandler<MSG>
    extends AbstractPacketHandler<MSG> {
        public static final NullPacketHandler<Object> INSTANCE = new NullPacketHandler();

        @Override
        public void accept(MSG msg, NetworkEvent.Context context) {
        }
    }
}

