/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.recipes;

import com.google.common.collect.Streams;
import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class RecipeSorter
extends SimplePreparableReloadListener<Void> {
    public static final RecipeSorter INSTANCE = new RecipeSorter();
    private int currentGeneration = 0;
    private int lastKnownGeneration = -1;
    private List<JumboFurnaceRecipe> cachedSortedRecipes = new ArrayList<JumboFurnaceRecipe>();

    public List<JumboFurnaceRecipe> getSortedFurnaceRecipes(RecipeManager manager) {
        if (this.currentGeneration != this.lastKnownGeneration) {
            this.cachedSortedRecipes = this.sortFurnaceRecipes(manager);
            this.lastKnownGeneration = this.currentGeneration;
        }
        return this.cachedSortedRecipes;
    }

    private List<JumboFurnaceRecipe> sortFurnaceRecipes(RecipeManager manager) {
        Stream<JumboFurnaceRecipe> basicRecipes = manager.m_44054_(RecipeType.f_44108_).values().stream().filter(recipe -> recipe instanceof SmeltingRecipe && recipe.m_43753_() <= (Integer)JumboFurnace.get().serverConfig.jumboFurnaceCookTime().get()).map(recipe -> new JumboFurnaceRecipe((SmeltingRecipe)recipe));
        Stream<JumboFurnaceRecipe> advancedRecipes = manager.m_44054_((RecipeType)JumboFurnace.get().jumboSmeltingRecipeType.get()).values().stream().filter(recipe -> recipe instanceof JumboFurnaceRecipe).map(recipe -> recipe);
        return Streams.concat((Stream[])new Stream[]{basicRecipes, advancedRecipes}).sorted(RecipeSorter::compareRecipes).collect(Collectors.toList());
    }

    public static int compareRecipes(JumboFurnaceRecipe a, JumboFurnaceRecipe b) {
        return b.getSpecificity() - a.getSpecificity();
    }

    protected Void prepare(ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        return null;
    }

    protected void apply(Void objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ++this.currentGeneration;
    }
}

