/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class JumboFurnaceRecipeSerializer
implements RecipeSerializer<JumboFurnaceRecipe> {
    public final RecipeType<JumboFurnaceRecipe> recipeType;

    public JumboFurnaceRecipeSerializer(RecipeType<JumboFurnaceRecipe> recipeType) {
        this.recipeType = recipeType;
    }

    public JumboFurnaceRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String groupName = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> ingredients = JumboFurnaceRecipeSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for jumbo furnace recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for jumbo furnace recipe! the max is 9");
        }
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        return new JumboFurnaceRecipe(this.recipeType, recipeId, groupName, ingredients, result, experience);
    }

    public static NonNullList<Ingredient> readIngredients(JsonArray p_199568_0_) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < p_199568_0_.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)p_199568_0_.get(i));
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public JumboFurnaceRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String groupName = buffer.m_130136_(Short.MAX_VALUE);
        int ingredientCount = buffer.m_130242_();
        NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
        for (int slot = 0; slot < ingredients.size(); ++slot) {
            ingredients.set(slot, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        ItemStack result = buffer.m_130267_();
        float experience = buffer.readFloat();
        return new JumboFurnaceRecipe(this.recipeType, recipeId, groupName, (NonNullList<Ingredient>)ingredients, result, experience);
    }

    public void toNetwork(FriendlyByteBuf buffer, JumboFurnaceRecipe recipe) {
        buffer.m_130070_(recipe.group);
        buffer.m_130130_(recipe.ingredients.size());
        for (Ingredient ingredient : recipe.ingredients) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130055_(recipe.result);
        buffer.writeFloat(recipe.experience);
    }
}

