/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.recipes;

import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.recipes.ClaimableRecipeWrapper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class JumboFurnaceRecipe
implements Recipe<ClaimableRecipeWrapper> {
    public final RecipeType<?> type;
    public final ResourceLocation id;
    public final String group;
    public final NonNullList<Ingredient> ingredients;
    public final ItemStack result;
    public final float experience;

    public JumboFurnaceRecipe(SmeltingRecipe baseRecipe) {
        this((RecipeType)JumboFurnace.get().jumboSmeltingRecipeType.get(), baseRecipe.m_6423_(), baseRecipe.m_6076_(), (NonNullList<Ingredient>)baseRecipe.m_7527_(), baseRecipe.f_43730_.m_41777_(), baseRecipe.m_43750_());
    }

    public JumboFurnaceRecipe(RecipeType<?> type, ResourceLocation id, String group, NonNullList<Ingredient> ingredients, ItemStack result, float experience) {
        this.type = type;
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.result = result;
        this.experience = experience;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean matches(ClaimableRecipeWrapper inv, Level worldIn) {
        IItemHandler unusedInputs = inv.getUnusedInputs();
        for (Ingredient ingredient : this.m_7527_()) {
            int amountOfIngredient = ingredient.m_43908_()[0].m_41613_();
            int slots = unusedInputs.getSlots();
            for (int slot = 0; slot < slots && amountOfIngredient > 0; ++slot) {
                ItemStack stackInSlot = unusedInputs.getStackInSlot(slot);
                if (!ingredient.test(stackInSlot) || stackInSlot.m_41613_() < amountOfIngredient) continue;
                ItemStack usedStack = unusedInputs.extractItem(slot, amountOfIngredient, false);
                amountOfIngredient -= usedStack.m_41613_();
            }
            if (amountOfIngredient <= 0) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(ClaimableRecipeWrapper inv, RegistryAccess registries) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registries) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)JumboFurnace.get().jumboSmeltingRecipeSerializer.get();
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public boolean m_5598_() {
        return true;
    }

    public int getSpecificity() {
        int specificity = (int)(this.experience * 10.0f);
        int totalItems = ForgeRegistries.ITEMS.getKeys().size();
        for (Ingredient ingredient : this.ingredients) {
            ItemStack[] matchingStacks = ingredient.m_43908_();
            if (matchingStacks.length < 1) continue;
            int matchingItems = Math.min(totalItems, matchingStacks.length);
            double matchFactor = (double)(totalItems - matchingItems) / (double)(totalItems - 1);
            int ingredientWeight = (int)(100.0 * (double)matchingStacks[0].m_41613_() * matchFactor);
            specificity += ingredientWeight;
        }
        return specificity;
    }

    public NonNullList<ItemStack> getRemainingItems(ClaimableRecipeWrapper inv) {
        IItemHandler items = inv.getItemsBeingSmelted();
        int slots = items.getSlots();
        NonNullList containerItems = NonNullList.m_122780_((int)items.getSlots(), (Object)ItemStack.f_41583_);
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stackInSlot = items.getStackInSlot(slot);
            if (!stackInSlot.hasCraftingRemainingItem()) continue;
            containerItems.set(slot, (Object)stackInSlot.getCraftingRemainingItem());
        }
        return containerItems;
    }
}

