/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class ClaimableRecipeWrapper
extends RecipeWrapper {
    private final IItemHandler unusedInputs;
    private final IItemHandler inputsBeingSmelted;
    private List<Recipe<ClaimableRecipeWrapper>> recipes = new ArrayList<Recipe<ClaimableRecipeWrapper>>();

    public ClaimableRecipeWrapper(IItemHandlerModifiable inv) {
        super(inv);
        int slots = inv.getSlots();
        this.unusedInputs = new ItemStackHandler(slots);
        this.inputsBeingSmelted = new ItemStackHandler(slots);
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stackCopy = inv.getStackInSlot(slot).m_41777_();
            for (int i = 0; i < slots && stackCopy.m_41613_() > 0; ++i) {
                stackCopy = this.unusedInputs.insertItem(i, stackCopy, false);
            }
        }
    }

    public List<Recipe<ClaimableRecipeWrapper>> getRecipes() {
        return this.recipes;
    }

    public IItemHandler getItemsBeingSmelted() {
        return this.inputsBeingSmelted;
    }

    public int getRecipeCount() {
        return this.recipes.size();
    }

    public boolean hasUnusedInputsLeft() {
        int slots = this.unusedInputs.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (this.unusedInputs.getStackInSlot(slot).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public IItemHandler getUnusedInputs() {
        int slots = this.unusedInputs.getSlots();
        ItemStackHandler result = new ItemStackHandler(slots);
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stackInSlot = this.unusedInputs.getStackInSlot(slot);
            result.insertItem(slot, stackInSlot.m_41777_(), false);
        }
        return result;
    }

    public boolean matchAndClaimInputs(Recipe<ClaimableRecipeWrapper> recipe, Level world, IItemHandler outputSimulator) {
        boolean hasRoomInOutput = ItemHandlerHelper.insertItem((IItemHandler)outputSimulator, (ItemStack)recipe.m_8043_(world.m_9598_()).m_41777_(), (boolean)true).m_41619_();
        if (!hasRoomInOutput) {
            return false;
        }
        boolean matched = recipe.m_5818_((Container)this, world);
        if (matched) {
            NonNullList ingredients = recipe.m_7527_();
            for (Ingredient ingredient : ingredients) {
                int amountOfIngredient = ingredient.m_43908_()[0].m_41613_();
                int slots = this.unusedInputs.getSlots();
                for (int slot = 0; slot < slots && amountOfIngredient > 0; ++slot) {
                    ItemStack stackInSlot = this.unusedInputs.getStackInSlot(slot);
                    if (!ingredient.test(stackInSlot) || stackInSlot.m_41613_() < amountOfIngredient) continue;
                    ItemStack usedStack = this.unusedInputs.extractItem(slot, amountOfIngredient, false);
                    int usedInputSlots = this.inputsBeingSmelted.getSlots();
                    amountOfIngredient -= usedStack.m_41613_();
                    for (int usedInputSlot = 0; usedInputSlot < usedInputSlots && usedStack.m_41613_() > 0; ++usedInputSlot) {
                        usedStack = this.inputsBeingSmelted.insertItem(usedInputSlot, usedStack, false);
                    }
                }
            }
            this.recipes.add(recipe);
            ItemHandlerHelper.insertItem((IItemHandler)outputSimulator, (ItemStack)recipe.m_8043_(world.m_9598_()).m_41777_(), (boolean)false);
        }
        return matched;
    }
}

