/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.jumbo_furnace;

import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class OutputItemHandler
extends ItemStackHandler {
    public static final String EXPERIENCE = "xp";
    public final JumboFurnaceCoreBlockEntity te;
    public boolean forcingInserts = false;
    public final float[] storedExperience;

    public OutputItemHandler(JumboFurnaceCoreBlockEntity te) {
        super(9);
        this.te = te;
        this.storedExperience = new float[9];
    }

    public void addExperience(int slot, float experience) {
        int n = slot;
        this.storedExperience[n] = this.storedExperience[n] + experience;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.forcingInserts;
    }

    public ItemStack insertCraftResult(int slot, ItemStack stack, boolean simulate) {
        this.forcingInserts = true;
        ItemStack result = this.insertItem(slot, stack, simulate);
        this.forcingInserts = false;
        return result;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.te.m_6596_();
        this.te.onOutputInventoryChanged();
    }

    public float getAndConsumeExperience(int index) {
        float amount = this.storedExperience[index];
        this.storedExperience[index] = 0.0f;
        return amount;
    }

    public CompoundTag serializeNBT() {
        CompoundTag result = super.serializeNBT();
        ListTag list = new ListTag();
        for (float experience : this.storedExperience) {
            list.add((Object)FloatTag.m_128566_((float)experience));
        }
        result.m_128365_(EXPERIENCE, (Tag)list);
        return result;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        ListTag list = nbt.m_128437_(EXPERIENCE, 5);
        int listSize = list.size();
        int slotCount = this.storedExperience.length;
        int slotsToRead = Math.min(listSize, slotCount);
        for (int i = 0; i < slotsToRead; ++i) {
            this.storedExperience[i] = list.m_128775_(i);
        }
    }
}

