/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.jumbo_furnace;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceBlock;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class MultiBlockHelper {
    public static final List<Pair<BlockPos, BlockState>> NO_SNAPSHOTS = ImmutableList.of();

    public static List<Pair<BlockPos, BlockState>> getJumboFurnaceStates(ResourceKey<Level> key, LevelAccessor world, BlockPos placePos, BlockState againstState, Entity entity) {
        return MultiBlockHelper.get3x3CubeAround(placePos).filter(pos -> MultiBlockHelper.canJumboFurnaceFormAt(world, pos, placePos)).map(pos -> MultiBlockHelper.getStatesForPlacementIfPermitted(key, world, pos, againstState, entity)).filter(list -> !list.isEmpty()).findFirst().orElse((List)ImmutableList.of());
    }

    public static boolean canJumboFurnaceFormAt(LevelAccessor world, BlockPos corePos, BlockPos placePos) {
        return MultiBlockHelper.get3x3CubeAround(corePos).allMatch(pos -> pos.equals((Object)placePos) || world.m_8055_(pos).m_204336_(JumboFurnace.JUMBOFURNACEABLE_TAG));
    }

    public static boolean canJumboFurnacePlaceAt(LevelAccessor world, BlockPos corePos, BlockPlaceContext useContext) {
        boolean noEntitiesInArea = world.m_45976_(LivingEntity.class, new AABB(corePos.m_7918_(-1, -1, -1), corePos.m_7918_(2, 2, 2))).isEmpty();
        return noEntitiesInArea && MultiBlockHelper.get3x3CubeAround(corePos).allMatch(pos -> world.m_8055_(pos).m_60629_(useContext));
    }

    public static Stream<BlockPos> get3x3CubeAround(BlockPos pos) {
        return BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1));
    }

    public static List<Pair<BlockPos, BlockState>> getStatesForPlacementIfPermitted(ResourceKey<Level> key, LevelAccessor world, BlockPos corePos, BlockState againstState, Entity placer) {
        List<Pair<BlockPos, BlockState>> pairs = ((JumboFurnaceBlock)((Object)JumboFurnace.get().jumboFurnaceBlock.get())).getStatesForFurnace(corePos);
        return MultiBlockHelper.doesPlayerHavePermissionToMakeJumboFurnace(key, world, pairs, againstState, placer) ? pairs : NO_SNAPSHOTS;
    }

    public static boolean doesPlayerHavePermissionToMakeJumboFurnace(ResourceKey<Level> key, LevelAccessor world, List<Pair<BlockPos, BlockState>> pairs, BlockState placedAgainst, Entity entity) {
        List snapshots = pairs.stream().map(pair -> BlockSnapshot.create((ResourceKey)key, (LevelAccessor)world, (BlockPos)((BlockPos)pair.getFirst()))).collect(Collectors.toList());
        BlockEvent.EntityMultiPlaceEvent event = new BlockEvent.EntityMultiPlaceEvent(snapshots, placedAgainst, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }
}

