/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.jumbo_furnace;

import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.JumboFurnaceUtils;
import commoble.jumbofurnace.advancements.UpgradeJumboFurnaceTrigger;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreBlockEntity;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceFuelSlot;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceOutputSlot;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceSyncData;
import commoble.jumbofurnace.jumbo_furnace.MultiprocessUpgradeHandler;
import commoble.jumbofurnace.jumbo_furnace.UninsertableItemStackHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class JumboFurnaceMenu
extends AbstractContainerMenu {
    public static final String TITLE = "container.jumbofurnace.jumbo_furnace";
    public static final int SLOT_SPACING = 18;
    public static final int INPUT_START_X = 8;
    public static final int INPUT_START_Y = 18;
    public static final int FUEL_START_X = 8;
    public static final int FUEL_START_Y = 90;
    public static final int OUTPUT_START_X = 116;
    public static final int OUTPUT_START_Y = 53;
    public static final int BACKPACK_START_X = 8;
    public static final int BACKPACK_START_Y = 158;
    public static final int HOTBAR_START_X = 8;
    public static final int HOTBAR_START_Y = 216;
    public static final int ORTHOFURNACE_SLOT_X = 134;
    public static final int ORTHOFURNACE_SLOT_Y = 117;
    public static final int SLOT_ROWS = 3;
    public static final int SLOT_COLUMNS = 3;
    public static final int BACKPACK_ROWS = 3;
    public static final int PLAYER_COLUMNS = 9;
    public static final int INPUT_SLOTS = 9;
    public static final int BACKPACK_SLOTS = 27;
    public static final int HOTBAR_SLOTS = 9;
    public static final int FIRST_INPUT_SLOT = 0;
    public static final int FIRST_FUEL_SLOT = 9;
    public static final int FIRST_OUTPUT_SLOT = 18;
    public static final int ORTHOFURNACE_SLOT = 27;
    public static final int FIRST_HOTBAR_SLOT = 28;
    public static final int FIRST_BACKPACK_SLOT = 37;
    public static final int FIRST_PLAYER_SLOT = 28;
    public static final int END_INPUT_SLOTS = 9;
    public static final int END_FUEL_SLOTS = 18;
    public static final int END_PLAYER_SLOTS = 64;
    private final ContainerLevelAccess usabilityTest;
    private final ContainerData furnaceData;
    private final Optional<JumboFurnaceCoreBlockEntity> serverFurnace;

    public static JumboFurnaceMenu getClientMenu(int id, Inventory playerInventory) {
        return new JumboFurnaceMenu(id, playerInventory, BlockPos.f_121853_, (IItemHandler)new ItemStackHandler(9), (IItemHandler)new ItemStackHandler(9), (IItemHandler)new UninsertableItemStackHandler(9), (IItemHandler)new ItemStackHandler(1), (ContainerData)new SimpleContainerData(4), Optional.empty());
    }

    public static MenuProvider getServerMenuProvider(JumboFurnaceCoreBlockEntity te, BlockPos activationPos) {
        return new SimpleMenuProvider((id, playerInventory, serverPlayer) -> new JumboFurnaceMenu(id, playerInventory, activationPos, (IItemHandler)te.input, (IItemHandler)te.fuel, (IItemHandler)te.output, (IItemHandler)te.multiprocessUpgradeHandler, new JumboFurnaceSyncData(te), Optional.of(te)), (Component)Component.m_237115_((String)TITLE));
    }

    protected JumboFurnaceMenu(int id, Inventory playerInventory, BlockPos pos, IItemHandler inputs, IItemHandler fuel, IItemHandler outputs, IItemHandler multiprocessUpgrades, ContainerData furnaceData, Optional<JumboFurnaceCoreBlockEntity> serverFurnace) {
        super((MenuType)JumboFurnace.get().jumboFurnaceMenuType.get(), id);
        int index;
        int x;
        int column;
        int y;
        int row;
        Player player = playerInventory.f_35978_;
        this.usabilityTest = ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)pos);
        this.furnaceData = furnaceData;
        this.serverFurnace = serverFurnace;
        for (row = 0; row < 3; ++row) {
            y = 18 + 18 * row;
            for (column = 0; column < 3; ++column) {
                x = 8 + 18 * column;
                index = row * 3 + column;
                this.m_38897_((Slot)new SlotItemHandler(inputs, index, x, y));
            }
        }
        for (row = 0; row < 3; ++row) {
            y = 90 + 18 * row;
            for (column = 0; column < 3; ++column) {
                x = 8 + 18 * column;
                index = row * 3 + column;
                this.m_38897_((Slot)new JumboFurnaceFuelSlot(fuel, index, x, y));
            }
        }
        for (row = 0; row < 3; ++row) {
            y = 53 + 18 * row;
            for (column = 0; column < 3; ++column) {
                x = 116 + 18 * column;
                index = row * 3 + column;
                this.m_38897_((Slot)new JumboFurnaceOutputSlot(player, outputs, index, x, y));
            }
        }
        this.m_38897_((Slot)new MultiprocessUpgradeHandler.MultiprocessUpgradeSlotHandler(multiprocessUpgrades, 0, 134, 117));
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            int x2 = 8 + 18 * hotbarSlot;
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, x2, 216));
        }
        for (row = 0; row < 3; ++row) {
            y = 158 + 18 * row;
            for (column = 0; column < 9; ++column) {
                x = 8 + 18 * column;
                index = row * 9 + column + 9;
                this.m_38897_(new Slot((Container)playerInventory, index, x, y));
            }
        }
        this.m_38884_(furnaceData);
    }

    public void m_6877_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack finalUpgradeStack = this.m_38853_(27).m_7993_();
            UpgradeJumboFurnaceTrigger.INSTANCE.test(serverPlayer, finalUpgradeStack);
        }
        super.m_6877_(player);
    }

    public boolean m_6875_(Player player) {
        return JumboFurnaceMenu.m_38889_((ContainerLevelAccess)this.usabilityTest, (Player)player, (Block)((Block)JumboFurnace.get().jumboFurnaceBlock.get()));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack slotStackCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            slotStackCopy = stackInSlot.m_41777_();
            if (index < 28) {
                if (!this.m_38903_(stackInSlot, 28, 64, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (stackInSlot.m_204117_(JumboFurnace.MULTIPROCESSING_UPGRADE_TAG)) {
                    if (this.m_38903_(stackInSlot, 27, 28, false)) {
                        this.serverFurnace.ifPresent(JumboFurnaceCoreBlockEntity::markInputInventoryChanged);
                    } else {
                        return ItemStack.f_41583_;
                    }
                }
                if (JumboFurnaceUtils.getJumboSmeltingBurnTime(stackInSlot) > 0) {
                    if (this.m_38903_(stackInSlot, 9, 18, false)) {
                        this.serverFurnace.ifPresent(JumboFurnaceCoreBlockEntity::markFuelInventoryChanged);
                    } else {
                        return ItemStack.f_41583_;
                    }
                }
                if (this.m_38903_(stackInSlot, 0, 9, false)) {
                    this.serverFurnace.ifPresent(JumboFurnaceCoreBlockEntity::markInputInventoryChanged);
                } else {
                    return ItemStack.f_41583_;
                }
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == slotStackCopy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return slotStackCopy;
    }

    public int getBurnTimeRemaining() {
        return this.furnaceData.m_6413_(0);
    }

    public int getItemBurnedValue() {
        return this.furnaceData.m_6413_(1);
    }

    public int getCookProgress() {
        return this.furnaceData.m_6413_(2);
    }

    public int getCookProgressionScaled() {
        int cookProgress = this.getCookProgress();
        int cookTimeForRecipe = (Integer)JumboFurnace.get().serverConfig.jumboFurnaceCookTime().get();
        return cookTimeForRecipe != 0 && cookProgress != 0 ? cookProgress * 24 / cookTimeForRecipe : 0;
    }

    public int getBurnLeftScaled() {
        int totalBurnTime = this.getItemBurnedValue();
        if (totalBurnTime == 0) {
            totalBurnTime = 200;
        }
        return this.getBurnTimeRemaining() * 13 / totalBurnTime;
    }

    public boolean isBurning() {
        return this.getBurnTimeRemaining() > 0;
    }
}

