/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.jumbo_furnace;

import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.JumboFurnaceUtils;
import commoble.jumbofurnace.jumbo_furnace.FuelItemHandler;
import commoble.jumbofurnace.jumbo_furnace.InputItemHandler;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceBlock;
import commoble.jumbofurnace.jumbo_furnace.MultiBlockHelper;
import commoble.jumbofurnace.jumbo_furnace.MultiprocessUpgradeHandler;
import commoble.jumbofurnace.jumbo_furnace.OutputItemHandler;
import commoble.jumbofurnace.recipes.ClaimableRecipeWrapper;
import commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import commoble.jumbofurnace.recipes.RecipeSorter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class JumboFurnaceCoreBlockEntity
extends BlockEntity {
    public static final String INPUT = "input";
    public static final String FUEL = "fuel";
    public static final String OUTPUT = "output";
    public static final String MULTIPROCESS_UPGRADES = "multiprocess_upgrades";
    public static final String COOK_PROGRESS = "cook_progress";
    public static final String BURN_TIME = "burn_time";
    public static final String BURN_VALUE = "burn_value";
    public static final BlockEntityTicker<JumboFurnaceCoreBlockEntity> SERVER_TICKER = (level, pos, state, core) -> core.serverTick();
    public final InputItemHandler input = new InputItemHandler(this);
    public final ItemStackHandler fuel = new FuelItemHandler(this);
    public final OutputItemHandler output = new OutputItemHandler(this);
    public final MultiprocessUpgradeHandler multiprocessUpgradeHandler = new MultiprocessUpgradeHandler(this);
    public final LazyOptional<IItemHandler> inputOptional = LazyOptional.of(() -> this.input);
    public final LazyOptional<IItemHandler> fuelOptional = LazyOptional.of(() -> this.fuel);
    public final LazyOptional<IItemHandler> outputOptional = LazyOptional.of(() -> this.output);
    public int burnTimeRemaining = 0;
    public int lastItemBurnedValue = 200;
    public int cookProgress = 0;
    public boolean isRoomToCook = true;
    public boolean canConsumeFuel = false;
    public ClaimableRecipeWrapper cachedRecipes = this.input.getFreshRecipeInput();
    public boolean needsRecipeUpdate = false;
    public boolean needsOutputUpdate = false;
    public boolean needsFuelUpdate = false;

    public static JumboFurnaceCoreBlockEntity create(BlockPos pos, BlockState state) {
        return new JumboFurnaceCoreBlockEntity((BlockEntityType<? extends JumboFurnaceCoreBlockEntity>)((BlockEntityType)JumboFurnace.get().jumboFurnaceCoreBlockEntityType.get()), pos, state);
    }

    protected JumboFurnaceCoreBlockEntity(BlockEntityType<? extends JumboFurnaceCoreBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void invalidateCaps() {
        this.inputOptional.invalidate();
        this.fuelOptional.invalidate();
        this.outputOptional.invalidate();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.input.deserializeNBT(compound.m_128469_(INPUT));
        this.fuel.deserializeNBT(compound.m_128469_(FUEL));
        this.output.deserializeNBT(compound.m_128469_(OUTPUT));
        this.multiprocessUpgradeHandler.deserializeNBT(compound.m_128469_(MULTIPROCESS_UPGRADES));
        this.cookProgress = compound.m_128451_(COOK_PROGRESS);
        this.burnTimeRemaining = compound.m_128451_(BURN_TIME);
        this.lastItemBurnedValue = compound.m_128451_(BURN_VALUE);
        this.onInputInventoryChanged();
        this.onOutputInventoryChanged();
        this.onFuelInventoryChanged();
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_(INPUT, (Tag)this.input.serializeNBT());
        compound.m_128365_(FUEL, (Tag)this.fuel.serializeNBT());
        compound.m_128365_(OUTPUT, (Tag)this.output.serializeNBT());
        compound.m_128365_(MULTIPROCESS_UPGRADES, (Tag)this.multiprocessUpgradeHandler.serializeNBT());
        compound.m_128405_(COOK_PROGRESS, this.cookProgress);
        compound.m_128405_(BURN_TIME, this.burnTimeRemaining);
        compound.m_128405_(BURN_VALUE, this.lastItemBurnedValue);
    }

    public int getBurnConsumption() {
        return Math.max(1, this.cachedRecipes.getRecipeCount());
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public void updateBurningBlockstates(boolean burning) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockState state = this.f_58857_.m_8055_(adjacentPos);
            if (!(state.m_60734_() instanceof JumboFurnaceBlock)) continue;
            this.f_58857_.m_46597_(adjacentPos, (BlockState)state.m_61124_((Property)JumboFurnaceBlock.LIT, (Comparable)Boolean.valueOf(burning)));
        }
    }

    public void markFuelInventoryChanged() {
        this.m_6596_();
        this.onFuelInventoryChanged();
    }

    public void onFuelInventoryChanged() {
        this.needsFuelUpdate = true;
    }

    public void markInputInventoryChanged() {
        this.m_6596_();
        this.onInputInventoryChanged();
    }

    public void onInputInventoryChanged() {
        this.needsRecipeUpdate = true;
    }

    public void markOutputInventoryCHanged() {
        this.m_6596_();
        this.onOutputInventoryChanged();
    }

    public void onOutputInventoryChanged() {
        this.needsOutputUpdate = true;
    }

    public int getMaxSimultaneousRecipes() {
        return 1 + this.multiprocessUpgradeHandler.getStackInSlot(0).m_41613_();
    }

    public void updateRecipes() {
        int slots = this.output.getSlots();
        ItemStackHandler outputSimulator = new ItemStackHandler(slots);
        for (int slot = 0; slot < slots; ++slot) {
            outputSimulator.setStackInSlot(slot, this.output.getStackInSlot(slot).m_41777_());
        }
        ClaimableRecipeWrapper wrapper = this.input.getFreshRecipeInput();
        List<JumboFurnaceRecipe> recipes = RecipeSorter.INSTANCE.getSortedFurnaceRecipes(this.f_58857_.m_7465_());
        for (JumboFurnaceRecipe recipe : recipes) {
            while (wrapper.getRecipeCount() < this.getMaxSimultaneousRecipes() && wrapper.matchAndClaimInputs(recipe, this.f_58857_, (IItemHandler)outputSimulator) && wrapper.hasUnusedInputsLeft()) {
            }
        }
        this.cachedRecipes = wrapper;
        this.needsRecipeUpdate = false;
        this.needsOutputUpdate = true;
    }

    public void updateOutput() {
        this.isRoomToCook = this.checkIfRoomToCook();
        this.needsOutputUpdate = false;
    }

    public boolean checkIfRoomToCook() {
        int slots = this.output.getSlots();
        ItemStackHandler outputSimulator = new ItemStackHandler(slots);
        for (int slot = 0; slot < slots; ++slot) {
            outputSimulator.setStackInSlot(slot, this.output.getStackInSlot(slot).m_41777_());
        }
        for (Recipe<ClaimableRecipeWrapper> recipe : this.cachedRecipes.getRecipes()) {
            ItemStack result = recipe.m_5874_((Container)this.cachedRecipes, this.f_58857_.m_9598_()).m_41777_();
            for (int slot = 0; slot < slots && !result.m_41619_(); ++slot) {
                result = outputSimulator.insertItem(slot, result, false);
            }
            if (result.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void updateFuel() {
        this.canConsumeFuel = this.checkIfCanConsumeFuel();
        this.needsFuelUpdate = false;
    }

    public boolean checkIfCanConsumeFuel() {
        int slots = this.fuel.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (JumboFurnaceUtils.getJumboSmeltingBurnTime(this.fuel.getStackInSlot(slot)) <= 0) continue;
            return true;
        }
        return false;
    }

    protected void serverTick() {
        boolean dirty = false;
        boolean wasBurningBeforeTick = this.isBurning();
        if (wasBurningBeforeTick) {
            this.burnTimeRemaining -= this.getBurnConsumption();
            dirty = true;
        }
        if (!this.f_58857_.f_46443_) {
            boolean hasSmeltableInputs;
            if (this.needsRecipeUpdate) {
                this.updateRecipes();
            }
            if (this.needsOutputUpdate) {
                this.updateOutput();
            }
            if (this.needsFuelUpdate) {
                this.updateFuel();
            }
            boolean bl = hasSmeltableInputs = this.cachedRecipes.getRecipeCount() > 0;
            if (this.isBurning() || this.canConsumeFuel && hasSmeltableInputs) {
                if (!this.isBurning() && hasSmeltableInputs) {
                    this.consumeFuel();
                }
                if (this.isBurning() && hasSmeltableInputs) {
                    ++this.cookProgress;
                    if (this.cookProgress >= (Integer)JumboFurnace.get().serverConfig.jumboFurnaceCookTime().get()) {
                        this.cookProgress = 0;
                        this.craft();
                    }
                    dirty = true;
                } else {
                    this.cookProgress = 0;
                    dirty = true;
                }
            } else if (!this.isBurning() && this.cookProgress > 0) {
                this.cookProgress = hasSmeltableInputs ? Math.max(0, this.cookProgress - 2) : 0;
                dirty = true;
            }
            boolean isBurningAfterTick = this.isBurning();
            if (isBurningAfterTick != wasBurningBeforeTick) {
                this.updateBurningBlockstates(isBurningAfterTick);
            }
            if (dirty) {
                this.m_6596_();
                BlockPos.m_121990_((BlockPos)this.m_58899_().m_7918_(-1, -1, -1), (BlockPos)this.m_58899_().m_7918_(1, 1, 1)).forEach(subPos -> {
                    BlockState state = this.f_58857_.m_8055_(subPos);
                    this.f_58857_.m_46672_(subPos, state.m_60734_());
                });
            }
        }
    }

    public void consumeFuel() {
        int slots = this.fuel.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stackInSlot = this.fuel.extractItem(slot, 1, true);
            int burnTime = JumboFurnaceUtils.getJumboSmeltingBurnTime(stackInSlot);
            if (burnTime <= 0) continue;
            this.lastItemBurnedValue = burnTime;
            this.fuel.extractItem(slot, 1, false);
            this.burnTimeRemaining += burnTime;
            if (!stackInSlot.hasCraftingRemainingItem()) break;
            this.fuel.setStackInSlot(slot, stackInSlot.getCraftingRemainingItem());
            break;
        }
    }

    public void craft() {
        ArrayList<ItemStack> extraItems = new ArrayList<ItemStack>();
        List<Recipe<ClaimableRecipeWrapper>> recipes = this.cachedRecipes.getRecipes();
        IItemHandler unusedInputs = this.cachedRecipes.getUnusedInputs();
        int unusedInputSlots = unusedInputs.getSlots();
        for (Recipe<ClaimableRecipeWrapper> recipe : recipes) {
            ItemStack result = recipe.m_5874_((Container)this.cachedRecipes, this.f_58857_.m_9598_());
            int outputSlots = this.output.getSlots();
            int resultCount = result.m_41613_();
            for (int slot = 0; slot < outputSlots && !result.m_41619_(); ++slot) {
                float f;
                int oldCount = result.m_41613_();
                result = this.output.insertCraftResult(slot, result, false);
                int newCount = result.m_41613_();
                int itemsInserted = oldCount - newCount;
                float f2 = (float)itemsInserted / (float)resultCount;
                if (recipe instanceof JumboFurnaceRecipe) {
                    JumboFurnaceRecipe jumboFurnaceRecipe = (JumboFurnaceRecipe)recipe;
                    f = jumboFurnaceRecipe.experience;
                } else {
                    f = 0.0f;
                }
                float experience = f2 * f;
                this.output.addExperience(slot, experience);
            }
            if (!result.m_41619_()) {
                extraItems.add(result);
            }
            for (ItemStack stack : recipe.m_7457_((Container)this.cachedRecipes)) {
                ItemStack containerItem = stack.m_41777_();
                for (int slot = 0; slot < unusedInputSlots && !containerItem.m_41619_(); ++slot) {
                    containerItem = unusedInputs.insertItem(slot, containerItem, false);
                }
                if (containerItem.m_41619_()) continue;
                extraItems.add(stack.m_41777_());
            }
        }
        for (int slot = 0; slot < unusedInputSlots; ++slot) {
            this.input.setStackInSlot(slot, unusedInputs.getStackInSlot(slot));
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_6625_(2));
        for (ItemStack stack : extraItems) {
            ItemStack stackCopy = stack.m_41777_();
            if (te != null) {
                stackCopy = te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).map(handler -> {
                    ItemStack innerStackCopy = stack.m_41777_();
                    int slots = handler.getSlots();
                    for (int slot = 0; slot < slots; ++slot) {
                        innerStackCopy = handler.insertItem(slot, innerStackCopy, false);
                    }
                    return innerStackCopy;
                }).orElse(stackCopy);
            }
            if (stackCopy.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() - 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)stack);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        MultiBlockHelper.get3x3CubeAround(this.f_58858_).filter(exteriorPos -> !exteriorPos.equals((Object)this.f_58858_)).forEach(exteriorPos -> this.f_58857_.m_46717_(exteriorPos, this.m_58900_().m_60734_()));
    }
}

