/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.jumbo_furnace;

import com.mojang.datafixers.util.Pair;
import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreBlockEntity;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceMenu;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceOutputSlot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class JumboFurnaceBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty X = IntegerProperty.m_61631_((String)"x", (int)0, (int)2);
    public static final IntegerProperty Y = IntegerProperty.m_61631_((String)"y", (int)0, (int)2);
    public static final IntegerProperty Z = IntegerProperty.m_61631_((String)"z", (int)0, (int)2);
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;

    public JumboFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)X, (Comparable)Integer.valueOf(0))).m_61124_((Property)Y, (Comparable)Integer.valueOf(0))).m_61124_((Property)Z, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{X, Y, Z, LIT});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.isCore(state) ? ((BlockEntityType)JumboFurnace.get().jumboFurnaceCoreBlockEntityType.get()).m_155264_(pos, state) : ((BlockEntityType)JumboFurnace.get().jumboFurnaceExteriorBlockEntityType.get()).m_155264_(pos, state);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        if (player.m_6144_() && handIn != null && stack.m_204117_(Tags.Items.SHEARS)) {
            return InteractionResult.SUCCESS;
        }
        BlockPos corePos = JumboFurnaceBlock.getCorePos(state, pos);
        BlockEntity be = level.m_7702_(corePos);
        if (be instanceof JumboFurnaceCoreBlockEntity) {
            JumboFurnaceCoreBlockEntity core = (JumboFurnaceCoreBlockEntity)be;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)JumboFurnaceMenu.getServerMenuProvider(core, pos));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, corePos, player, handIn, hit);
    }

    @Deprecated
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof JumboFurnaceCoreBlockEntity) {
                JumboFurnaceCoreBlockEntity core = (JumboFurnaceCoreBlockEntity)be;
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                double x = (double)pos.m_123341_() + 0.5;
                double y = (double)pos.m_123342_() + 0.5;
                double z = (double)pos.m_123343_() + 0.5;
                float experience = 0.0f;
                for (int i = 0; i < 9; ++i) {
                    drops.add(core.input.getStackInSlot(i));
                    drops.add(core.fuel.getStackInSlot(i));
                    drops.add(core.output.getStackInSlot(i));
                    experience += core.output.storedExperience[i];
                }
                drops.add(core.multiprocessUpgradeHandler.getStackInSlot(0));
                for (ItemStack drop : drops) {
                    Containers.m_18992_((Level)level, (double)x, (double)y, (double)z, (ItemStack)drop);
                }
                Player player = level.m_5788_(x, y, z, 16.0, null);
                if (player != null) {
                    JumboFurnaceOutputSlot.spawnExpOrbs(player, experience);
                }
            }
            if (!isMoving) {
                this.destroyNextBlockPos(level, state, pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void destroyNextBlockPos(Level level, BlockState state, BlockPos pos) {
        int zIndex;
        int nextZIndex;
        int yIndex;
        int nextYIndex;
        int xIndex;
        int nextXIndex;
        BlockPos nextPos;
        BlockState nextState;
        if (state.m_61138_((Property)X) && state.m_61138_((Property)Y) && state.m_61138_((Property)Z) && (nextState = level.m_8055_(nextPos = pos.m_7918_((nextXIndex = ((xIndex = ((Integer)state.m_61143_((Property)X)).intValue()) + 1) % 3) - xIndex, (nextYIndex = xIndex == 2 ? (yIndex + 1) % 3 : yIndex) - (yIndex = ((Integer)state.m_61143_((Property)Y)).intValue()), (nextZIndex = xIndex == 2 && yIndex == 2 ? (zIndex + 1) % 3 : zIndex) - (zIndex = ((Integer)state.m_61143_((Property)Z)).intValue())))).m_60734_() == this) {
            level.m_46961_(nextPos, true);
        }
    }

    public static BlockPos getCorePos(BlockState exteriorState, BlockPos exteriorPos) {
        int xOff = exteriorState.m_61138_((Property)X) ? 1 - (Integer)exteriorState.m_61143_((Property)X) : 0;
        int yOff = exteriorState.m_61138_((Property)Y) ? 1 - (Integer)exteriorState.m_61143_((Property)Y) : 0;
        int zOff = exteriorState.m_61138_((Property)Z) ? 1 - (Integer)exteriorState.m_61143_((Property)Z) : 0;
        return exteriorPos.m_7918_(xOff, yOff, zOff);
    }

    public boolean isCore(BlockState state) {
        return state.m_61138_((Property)X) && state.m_61138_((Property)Y) && state.m_61138_((Property)Z) && (Integer)state.m_61143_((Property)X) == 1 && (Integer)state.m_61143_((Property)Y) == 1 && (Integer)state.m_61143_((Property)Z) == 1;
    }

    public List<Pair<BlockPos, BlockState>> getStatesForFurnace(BlockPos corePos) {
        ArrayList<Pair<BlockPos, BlockState>> pairs = new ArrayList<Pair<BlockPos, BlockState>>(27);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    BlockState state = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)X, (Comparable)Integer.valueOf(x))).m_61124_((Property)Y, (Comparable)Integer.valueOf(y))).m_61124_((Property)Z, (Comparable)Integer.valueOf(z));
                    BlockPos pos = corePos.m_7918_(x - 1, y - 1, z - 1);
                    pairs.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos, (Object)state));
                }
            }
        }
        return pairs;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            Direction direction;
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (rand.m_188500_() < 0.1) {
                level.m_7785_(x, y, z, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if ((direction = this.getSmelterHoleDirection(state)) != null) {
                Direction.Axis axis = direction.m_122434_();
                double orthagonalOffset = rand.m_188500_() * 0.6 - 0.3;
                double xOff = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : orthagonalOffset;
                double yOff = rand.m_188500_() * 6.0 / 16.0;
                double zOff = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : orthagonalOffset;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xOff, y + yOff, z + zOff, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + xOff, y + yOff, z + zOff, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public Direction getSmelterHoleDirection(BlockState state) {
        if (!(state.m_61138_((Property)X) && state.m_61138_((Property)Y) && state.m_61138_((Property)Z))) {
            return null;
        }
        int y = (Integer)state.m_61143_((Property)Y);
        if (y != 1) {
            return null;
        }
        int x = (Integer)state.m_61143_((Property)X);
        int z = (Integer)state.m_61143_((Property)Z);
        if (x == 1 && z == 0) {
            return Direction.NORTH;
        }
        if (x == 1 && z == 2) {
            return Direction.SOUTH;
        }
        if (x == 0 && z == 1) {
            return Direction.WEST;
        }
        if (x == 2 && z == 1) {
            return Direction.EAST;
        }
        return null;
    }

    @Deprecated
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        JumboFurnaceCoreBlockEntity core;
        block8: {
            block7: {
                BlockPos corePos = JumboFurnaceBlock.getCorePos(state, pos);
                BlockEntity be = level.m_7702_(corePos);
                if (!(be instanceof JumboFurnaceCoreBlockEntity)) break block7;
                core = (JumboFurnaceCoreBlockEntity)be;
                if (state.m_61138_((Property)Y)) break block8;
            }
            return 0;
        }
        int y = (Integer)state.m_61143_((Property)Y);
        switch (y) {
            case 0: {
                return JumboFurnaceBlock.calcRedstoneFromItemHandler((IItemHandler)core.output);
            }
            case 1: {
                return JumboFurnaceBlock.calcRedstoneFromItemHandler((IItemHandler)core.fuel);
            }
            case 2: {
                return JumboFurnaceBlock.calcRedstoneFromItemHandler((IItemHandler)core.input);
            }
        }
        return 0;
    }

    public static int calcRedstoneFromItemHandler(@Nonnull IItemHandler handler) {
        int nonEmptySlots = 0;
        float totalItemValue = 0.0f;
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack itemstack = handler.getStackInSlot(slot);
            if (itemstack.m_41619_()) continue;
            totalItemValue += (float)itemstack.m_41613_() / (float)Math.min(handler.getSlotLimit(slot), itemstack.m_41741_());
            ++nonEmptySlots;
        }
        float averageItemValue = totalItemValue / (float)slots;
        return Mth.m_14143_((float)(averageItemValue * 14.0f)) + (nonEmptySlots > 0 ? 1 : 0);
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (state.m_61138_((Property)X) && state.m_61138_((Property)Z)) {
            int x = (Integer)state.m_61143_((Property)X);
            int z = (Integer)state.m_61143_((Property)Z);
            switch (rot) {
                case NONE: {
                    return state;
                }
                case CLOCKWISE_90: {
                    return (BlockState)((BlockState)state.m_61124_((Property)X, (Comparable)Integer.valueOf(2 - z))).m_61124_((Property)Z, (Comparable)Integer.valueOf(x));
                }
                case CLOCKWISE_180: {
                    return (BlockState)((BlockState)state.m_61124_((Property)X, (Comparable)Integer.valueOf(2 - x))).m_61124_((Property)Z, (Comparable)Integer.valueOf(2 - z));
                }
                case COUNTERCLOCKWISE_90: {
                    return (BlockState)((BlockState)state.m_61124_((Property)X, (Comparable)Integer.valueOf(z))).m_61124_((Property)Z, (Comparable)Integer.valueOf(2 - x));
                }
            }
            return state;
        }
        return super.m_6843_(state, rot);
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (state.m_61138_((Property)X) && state.m_61138_((Property)Z)) {
            switch (mirror) {
                case NONE: {
                    return state;
                }
                case LEFT_RIGHT: {
                    return (BlockState)state.m_61124_((Property)Z, (Comparable)Integer.valueOf(2 - (Integer)state.m_61143_((Property)Z)));
                }
                case FRONT_BACK: {
                    return (BlockState)state.m_61124_((Property)X, (Comparable)Integer.valueOf(2 - (Integer)state.m_61143_((Property)X)));
                }
            }
            return state;
        }
        return super.m_6943_(state, mirror);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == JumboFurnace.get().jumboFurnaceCoreBlockEntityType.get() && !level.f_46443_ ? JumboFurnaceCoreBlockEntity.SERVER_TICKER : null;
    }
}

