/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.client.jei;

import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.client.jei.JEIProxy;
import commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class JumboSmeltingCategory
implements IRecipeCategory<JumboFurnaceRecipe> {
    public static final RecipeType<JumboFurnaceRecipe> TYPE = RecipeType.create((String)"jumbofurnace", (String)"jumbo_smelting", JumboFurnaceRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic staticFlame;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableStatic backgroundFlame;

    public JumboSmeltingCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)JumboFurnace.get().jumboFurnaceJeiDummy.get()));
        this.background = helper.createDrawable(JEIProxy.JEI_RECIPE_TEXTURE, 0, 60, 116, 54);
        this.arrow = helper.drawableBuilder(JEIProxy.JEI_RECIPE_TEXTURE, 82, 128, 24, 17).buildAnimated(((Integer)JumboFurnace.get().serverConfig.jumboFurnaceCookTime().get()).intValue(), IDrawableAnimated.StartDirection.LEFT, false);
        this.staticFlame = helper.createDrawable(JEIProxy.JEI_RECIPE_TEXTURE, 82, 114, 14, 14);
        this.animatedFlame = helper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.backgroundFlame = helper.createDrawable(JEIProxy.JEI_RECIPE_TEXTURE, 1, 134, 14, 14);
    }

    public RecipeType<JumboFurnaceRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.jumbofurnace.category.jumbo_smelting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(JumboFurnaceRecipe recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        this.backgroundFlame.draw(graphics, 66, 38);
        this.animatedFlame.draw(graphics, 66, 38);
        this.arrow.draw(graphics, 60, 18);
        float experience = recipe.experience;
        if (experience > 0.0f) {
            String experienceString = I18n.m_118938_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92895_(experienceString);
            graphics.m_280056_(fontRenderer, experienceString, this.background.getWidth() - stringWidth, 0, -8355712, false);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, JumboFurnaceRecipe recipe, IFocusGroup focuses) {
        recipeLayout.setShapeless(60, 0);
        recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStack(recipe.result);
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        int ingredientCount = ingredients.size();
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int inputID = row * 3 + column;
                IRecipeSlotBuilder slot = recipeLayout.addSlot(RecipeIngredientRole.INPUT, column * 18 + 1, row * 18 + 1);
                if (inputID >= ingredientCount) continue;
                slot.addIngredients((Ingredient)ingredients.get(inputID));
            }
        }
    }
}

