/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.client.jei;

import com.google.common.collect.ImmutableList;
import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.client.jei.JumboFurnaceUpgradeCategory;
import commoble.jumbofurnace.client.jei.JumboSmeltingCategory;
import commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import commoble.jumbofurnace.recipes.RecipeSorter;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIProxy
implements IModPlugin {
    public static final ResourceLocation JEI_RECIPE_TEXTURE = new ResourceLocation("jei", "textures/jei/gui/gui_vanilla.png");
    @Nullable
    private JumboSmeltingCategory jumboSmeltingCategory;
    @Nullable
    private JumboFurnaceUpgradeCategory jumboFurnaceUpgradeCategory;
    public static final ResourceLocation ID = new ResourceLocation("jumbofurnace", "jumbofurnace");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        this.jumboSmeltingCategory = new JumboSmeltingCategory(helper);
        this.jumboFurnaceUpgradeCategory = new JumboFurnaceUpgradeCategory(helper);
        registration.addRecipeCategories(new IRecipeCategory[]{this.jumboSmeltingCategory, this.jumboFurnaceUpgradeCategory});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)JumboFurnace.get().jumboFurnaceJeiDummy.get()), new RecipeType[]{JumboSmeltingCategory.TYPE, JumboFurnaceUpgradeCategory.TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (this.jumboSmeltingCategory == null || this.jumboFurnaceUpgradeCategory == null) {
            throw new NullPointerException("Jumbo Furnace's Jumbo Smelting JEI categories failed to register! Notify the developer for assistance https://github.com/Commoble/jumbo-furnace/issues");
        }
        registration.addRecipes(JumboSmeltingCategory.TYPE, this.getRecipes());
        registration.addRecipes(JumboFurnaceUpgradeCategory.TYPE, List.of(JumboFurnaceUpgradeCategory.JumboFurnaceUpgrade.INSTANCE));
    }

    public List<JumboFurnaceRecipe> getRecipes() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            RecipeManager manager = world.m_7465_();
            return RecipeSorter.INSTANCE.getSortedFurnaceRecipes(manager);
        }
        return ImmutableList.of();
    }
}

