/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace;

import com.mojang.datafixers.util.Pair;
import commoble.jumbofurnace.advancements.AssembleJumboFurnaceTrigger;
import commoble.jumbofurnace.advancements.UpgradeJumboFurnaceTrigger;
import commoble.jumbofurnace.client.ClientProxy;
import commoble.jumbofurnace.config.ConfigHelper;
import commoble.jumbofurnace.config.ServerConfig;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceBlock;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreBlockEntity;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceExteriorBlockEntity;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceItem;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceMenu;
import commoble.jumbofurnace.jumbo_furnace.MultiBlockHelper;
import commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import commoble.jumbofurnace.recipes.JumboFurnaceRecipeSerializer;
import commoble.jumbofurnace.recipes.RecipeSorter;
import commoble.jumbofurnace.recipes.TagStackIngredient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="jumbofurnace")
public class JumboFurnace {
    private static JumboFurnace instance;
    public static final String MODID = "jumbofurnace";
    public static final TagKey<Block> JUMBOFURNACEABLE_TAG;
    public static final TagKey<Item> MULTIPROCESSING_UPGRADE_TAG;
    public final ServerConfig serverConfig;
    public final RegistryObject<JumboFurnaceBlock> jumboFurnaceBlock;
    public final RegistryObject<JumboFurnaceItem> jumboFurnaceItem;
    public final RegistryObject<Item> jumboFurnaceJeiDummy;
    public final RegistryObject<BlockEntityType<JumboFurnaceCoreBlockEntity>> jumboFurnaceCoreBlockEntityType;
    public final RegistryObject<BlockEntityType<JumboFurnaceExteriorBlockEntity>> jumboFurnaceExteriorBlockEntityType;
    public final RegistryObject<MenuType<JumboFurnaceMenu>> jumboFurnaceMenuType;
    public final RegistryObject<RecipeType<JumboFurnaceRecipe>> jumboSmeltingRecipeType;
    public final RegistryObject<RecipeSerializer<JumboFurnaceRecipe>> jumboSmeltingRecipeSerializer;

    public static JumboFurnace get() {
        return instance;
    }

    public JumboFurnace() {
        if (instance != null) {
            throw new IllegalStateException("Jumbo Furnace initialized twice!");
        }
        instance = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        this.serverConfig = ConfigHelper.register(ModConfig.Type.SERVER, ServerConfig::create);
        DeferredRegister blocks = this.makeDeferredRegister(modBus, Registries.f_256747_);
        DeferredRegister items = this.makeDeferredRegister(modBus, Registries.f_256913_);
        DeferredRegister blockEntities = this.makeDeferredRegister(modBus, Registries.f_256922_);
        DeferredRegister menus = this.makeDeferredRegister(modBus, Registries.f_256798_);
        DeferredRegister recipeTypes = this.makeDeferredRegister(modBus, Registries.f_256954_);
        DeferredRegister recipeSerializers = this.makeDeferredRegister(modBus, Registries.f_256764_);
        this.jumboFurnaceBlock = blocks.register("jumbo_furnace", () -> new JumboFurnaceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50094_)));
        this.jumboFurnaceItem = items.register("jumbo_furnace", () -> new JumboFurnaceItem(new Item.Properties()));
        this.jumboFurnaceJeiDummy = items.register("jumbo_furnace_jei", () -> new Item(new Item.Properties()){

            @OnlyIn(value=Dist.CLIENT)
            public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                tooltip.add((Component)Component.m_237115_((String)"jumbofurnace.jumbo_furnace_info_tooltip"));
            }
        });
        this.jumboFurnaceCoreBlockEntityType = blockEntities.register("jumbo_furnace_core", () -> BlockEntityType.Builder.m_155273_(JumboFurnaceCoreBlockEntity::create, (Block[])new Block[]{(Block)this.jumboFurnaceBlock.get()}).m_58966_(null));
        this.jumboFurnaceExteriorBlockEntityType = blockEntities.register("jumbo_furnace_exterior", () -> BlockEntityType.Builder.m_155273_(JumboFurnaceExteriorBlockEntity::create, (Block[])new Block[]{(Block)this.jumboFurnaceBlock.get()}).m_58966_(null));
        this.jumboFurnaceMenuType = menus.register("jumbo_furnace", () -> new MenuType(JumboFurnaceMenu::getClientMenu, FeatureFlags.f_244377_));
        this.jumboSmeltingRecipeType = recipeTypes.register("jumbo_smelting", () -> RecipeType.simple((ResourceLocation)new ResourceLocation(MODID, "jumbo_smelting")));
        this.jumboSmeltingRecipeSerializer = recipeSerializers.register("jumbo_smelting", () -> new JumboFurnaceRecipeSerializer((RecipeType<JumboFurnaceRecipe>)((RecipeType)this.jumboSmeltingRecipeType.get())));
        modBus.addListener(this::onBuildCreativeTabs);
        modBus.addListener(this::onCommonSetup);
        forgeBus.addListener(this::onAddServerReloadListeners);
        forgeBus.addListener(this::onEntityPlaceBlock);
        forgeBus.addListener(EventPriority.LOW, this::onRightClickBlockLow);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientProxy.addClientListeners(modBus, forgeBus);
        }
    }

    private <T> DeferredRegister<T> makeDeferredRegister(IEventBus modBus, ResourceKey<Registry<T>> registryKey) {
        DeferredRegister register = DeferredRegister.create(registryKey, (String)MODID);
        register.register(modBus);
        return register;
    }

    private void onAddServerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)RecipeSorter.INSTANCE);
    }

    private void onEntityPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        block10: {
            BlockState state = event.getPlacedBlock();
            LevelAccessor levelAccess = event.getLevel();
            if (event instanceof BlockEvent.EntityMultiPlaceEvent || !state.m_204336_(JUMBOFURNACEABLE_TAG) || !(levelAccess instanceof Level)) break block10;
            BlockPos pos = event.getPos();
            BlockState againstState = event.getPlacedAgainst();
            Entity entity = event.getEntity();
            ArrayList stacks = new ArrayList();
            List<Pair<BlockPos, BlockState>> pairs = MultiBlockHelper.getJumboFurnaceStates((ResourceKey<Level>)((Level)levelAccess).m_46472_(), levelAccess, pos, againstState, entity);
            if (pairs.size() > 0) {
                for (Pair<BlockPos, BlockState> pair : pairs) {
                    BlockPos newPos = (BlockPos)pair.getFirst();
                    BlockState newState = (BlockState)pair.getSecond();
                    BlockEntity te = levelAccess.m_7702_(newPos);
                    if (te != null) {
                        for (Direction dir : Direction.values()) {
                            te.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).ifPresent(handler -> JumboFurnace.addItemsToList(stacks, handler));
                        }
                        te.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> JumboFurnace.addItemsToList(stacks, handler));
                    }
                    levelAccess.m_7731_(newPos, newState, 3);
                }
                if (entity instanceof ServerPlayer) {
                    AssembleJumboFurnaceTrigger.INSTANCE.trigger((ServerPlayer)entity);
                }
            }
            if (!stacks.isEmpty()) {
                if (entity instanceof Player) {
                    for (ItemStack stack : stacks) {
                        ((Player)entity).m_36356_(stack);
                    }
                } else {
                    for (ItemStack stack : stacks) {
                        entity.m_19983_(stack);
                    }
                }
            }
        }
    }

    private void onRightClickBlockLow(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)this.serverConfig.allowShearing().get()).booleanValue() && event.getUseItem() != Event.Result.DENY && event.getUseBlock() != Event.Result.DENY) {
            BlockPos pos;
            Level level;
            BlockState state;
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            if (player.m_36341_() && stack.m_204117_(Tags.Items.SHEARS) && (state = (level = event.getLevel()).m_8055_(pos = event.getPos())).m_60734_() == this.jumboFurnaceBlock.get()) {
                if (!level.f_46443_) {
                    BlockPos corePos = JumboFurnaceBlock.getCorePos(state, pos);
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.jumboFurnaceItem.get()));
                    InteractionHand hand = event.getHand();
                    stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
                    MultiBlockHelper.get3x3CubeAround(corePos).forEach(componentPos -> level.m_7471_(componentPos, true));
                }
                level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private void onBuildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(this.jumboFurnaceItem);
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> this.afterCommonSetup());
    }

    private void afterCommonSetup() {
        CriteriaTriggers.m_10595_((CriterionTrigger)AssembleJumboFurnaceTrigger.INSTANCE);
        CriteriaTriggers.m_10595_((CriterionTrigger)UpgradeJumboFurnaceTrigger.INSTANCE);
        CraftingHelper.register((ResourceLocation)new ResourceLocation("jumbofurnace:tag_stack"), TagStackIngredient.SERIALIZER);
    }

    private static void addItemsToList(List<ItemStack> stacks, IItemHandler handler) {
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = handler.extractItem(slot, 64, false);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
    }

    static {
        JUMBOFURNACEABLE_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MODID, "jumbofurnaceable"));
        MULTIPROCESSING_UPGRADE_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(MODID, "multiprocessing_upgrade"));
    }
}

