/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.utils;

import com.google.common.collect.AbstractIterator;
import io.github.flemmli97.improvedmobs.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CustomBlockCollision
extends AbstractIterator<VoxelShape> {
    private final AABB box;
    private final CollisionContext context;
    private final Cursor3D cursor;
    private final BlockPos.MutableBlockPos pos;
    private final VoxelShape entityShape;
    private final CollisionGetter collisionGetter;
    @Nullable
    private BlockGetter cachedBlockGetter;
    private long cachedBlockGetterPos;
    private final Entity entity;

    public CustomBlockCollision(CollisionGetter collisionGetter, @Nullable Entity entity, AABB aABB) {
        this.entity = entity;
        this.context = entity == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)entity);
        this.pos = new BlockPos.MutableBlockPos();
        this.entityShape = Shapes.m_83064_((AABB)aABB);
        this.collisionGetter = collisionGetter;
        this.box = aABB;
        int i = Mth.m_14107_((double)(aABB.f_82288_ - 1.0E-7)) - 1;
        int j = Mth.m_14107_((double)(aABB.f_82291_ + 1.0E-7)) + 1;
        int k = Mth.m_14107_((double)(aABB.f_82289_ - 1.0E-7)) - 1;
        int l = Mth.m_14107_((double)(aABB.f_82292_ + 1.0E-7)) + 1;
        int m = Mth.m_14107_((double)(aABB.f_82290_ - 1.0E-7)) - 1;
        int n = Mth.m_14107_((double)(aABB.f_82293_ + 1.0E-7)) + 1;
        this.cursor = new Cursor3D(i, k, m, j, l, n);
    }

    @Nullable
    private BlockGetter getChunk(int i, int j) {
        BlockGetter blockGetter;
        int k = SectionPos.m_123171_((int)i);
        int l = SectionPos.m_123171_((int)j);
        long m = ChunkPos.m_45589_((int)k, (int)l);
        if (this.cachedBlockGetter != null && this.cachedBlockGetterPos == m) {
            return this.cachedBlockGetter;
        }
        this.cachedBlockGetter = blockGetter = this.collisionGetter.m_7925_(k, l);
        this.cachedBlockGetterPos = m;
        return blockGetter;
    }

    protected VoxelShape computeNext() {
        while (this.cursor.m_122304_()) {
            BlockGetter blockGetter;
            int i = this.cursor.m_122305_();
            int j = this.cursor.m_122306_();
            int k = this.cursor.m_122307_();
            int l = this.cursor.m_122308_();
            if (l == 3 || (blockGetter = this.getChunk(i, k)) == null) continue;
            this.pos.m_122178_(i, j, k);
            BlockState blockState = blockGetter.m_8055_((BlockPos)this.pos);
            if (Config.CommonConfig.breakableBlocks.canBreak(blockState, (BlockPos)this.pos, blockGetter, this.entity, this.context) || l == 1 && !blockState.m_60779_() || l == 2 && !blockState.m_60713_(Blocks.f_50110_)) continue;
            VoxelShape voxelShape = blockState.m_60742_((BlockGetter)this.collisionGetter, (BlockPos)this.pos, this.context);
            if (voxelShape == Shapes.m_83144_()) {
                if (!this.box.m_82314_((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0)) continue;
                return voxelShape.m_83216_((double)i, (double)j, (double)k);
            }
            VoxelShape voxelShape2 = voxelShape.m_83216_((double)i, (double)j, (double)k);
            if (!Shapes.m_83157_((VoxelShape)voxelShape2, (VoxelShape)this.entityShape, (BooleanOp)BooleanOp.f_82689_)) continue;
            return voxelShape2;
        }
        return (VoxelShape)this.endOfData();
    }
}

