/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai.util;

import com.google.common.collect.Lists;
import io.github.flemmli97.improvedmobs.ai.util.AIUtils;
import io.github.flemmli97.improvedmobs.ai.util.ItemAI;
import io.github.flemmli97.improvedmobs.mixinhelper.ITNTThrowable;
import io.github.flemmli97.improvedmobs.utils.EntityFlags;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemAIs {
    private static final List<Supplier<MobEffect>> potionEffects = Lists.newArrayList((Object[])new Supplier[]{() -> MobEffects.f_19605_, () -> MobEffects.f_19596_, () -> MobEffects.f_19600_, () -> MobEffects.f_19609_, () -> MobEffects.f_19606_, () -> MobEffects.f_19607_});
    public static final ItemAI ENCHANTEDBOOK = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            block7: {
                if (entity.m_9236_().f_46443_) break block7;
                List nearby = entity.m_9236_().m_45933_((Entity)entity, entity.m_20191_().m_82400_(8.0));
                List nearTarget = entity.m_9236_().m_45933_((Entity)entity.m_5448_(), entity.m_5448_().m_20191_().m_82400_(2.0));
                if (nearby.isEmpty() || nearby.size() == 1 && nearby.get(0) == entity.m_5448_() || entity.m_9236_().f_46441_.m_188503_(3) <= 1) {
                    if (nearTarget.isEmpty()) {
                        for (int x = -1; x <= 1; ++x) {
                            for (int z = -1; z <= 1; ++z) {
                                if (x != 0 && z != 0) continue;
                                Vec3 targetMotion = target.m_20184_();
                                EvokerFangs fang = new EvokerFangs(entity.m_9236_(), target.m_20185_() + (double)x + targetMotion.f_82479_, target.m_20186_(), target.m_20189_() + (double)z + targetMotion.f_82481_, 0.0f, 5, (LivingEntity)entity);
                                entity.m_9236_().m_7967_((Entity)fang);
                            }
                        }
                    } else {
                        ShulkerBullet bullet = new ShulkerBullet(entity.m_9236_(), (LivingEntity)entity, (Entity)target, entity.m_6350_().m_122434_());
                        EntityFlags.get((Entity)bullet).isThrownEntity = true;
                        entity.m_9236_().m_7967_((Entity)bullet);
                    }
                } else {
                    for (int i = 0; i < nearby.size(); ++i) {
                        Entity entityRand = (Entity)nearby.get(entity.m_9236_().f_46441_.m_188503_(nearby.size()));
                        if (!(entityRand instanceof Monster)) continue;
                        Monster mob = (Monster)entityRand;
                        if (entityRand == entity.m_5448_()) continue;
                        mob.m_7292_(new MobEffectInstance(potionEffects.get(mob.m_9236_().f_46441_.m_188503_(6)).get(), 3600, 1));
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11880_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                        return;
                    }
                }
            }
        }

        @Override
        public int cooldown() {
            return 80;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STANDING;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI TRIDENT = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            AIUtils.tridentAttack(entity, target);
        }

        @Override
        public int cooldown() {
            return 65;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STANDING;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean useHand() {
            return true;
        }

        @Override
        public int maxUseCount(Mob entity, InteractionHand hand) {
            return 40;
        }
    };
    public static final ItemAI TNT = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            double dis = entity.m_20182_().m_82554_(target.m_20182_());
            if (!entity.m_9236_().f_46443_) {
                PrimedTnt tnt = new PrimedTnt(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (LivingEntity)entity);
                ((ITNTThrowable)tnt).shootFromEntity((Entity)entity, entity.m_146909_(), entity.m_146908_(), -20.0f, 0.2f + (float)(dis * 0.05), 1.0f);
                EntityFlags.get((Entity)tnt).isThrownEntity = true;
                entity.m_9236_().m_7967_((Entity)tnt);
            }
        }

        @Override
        public int cooldown() {
            return 65;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI FLINT_N_STEEL = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            double dis = entity.m_20182_().m_82554_(target.m_20182_());
            if (dis < (double)(entity.m_20205_() + target.m_20205_()) + 0.5 && !target.m_6060_()) {
                target.m_20254_(4);
            }
        }

        @Override
        public int cooldown() {
            return 25;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI SPLASH = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            ItemStack stack = entity.m_21120_(hand);
            if (AIUtils.isBadPotion(stack)) {
                double dis = entity.m_20182_().m_82554_(target.m_20182_());
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12437_, SoundSource.NEUTRAL, 0.5f, 0.4f / (entity.m_9236_().f_46441_.m_188501_() * 0.4f + 0.8f));
                if (!entity.m_9236_().f_46443_) {
                    ThrownPotion potion = new ThrownPotion(entity.m_9236_(), (LivingEntity)entity);
                    potion.m_37446_(stack);
                    potion.m_37251_((Entity)entity, entity.m_146909_(), entity.m_146908_(), -30.0f, 0.2f + (float)(dis * 0.05), 1.2f);
                    EntityFlags.get((Entity)potion).isThrownEntity = true;
                    entity.m_9236_().m_7967_((Entity)potion);
                }
            }
        }

        @Override
        public int cooldown() {
            return 85;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean applies(ItemStack stack) {
            return AIUtils.isBadPotion(stack);
        }
    };
    public static final ItemAI LINGERINGPOTIONS = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            ItemStack stack = entity.m_21120_(hand);
            if (AIUtils.isBadPotion(stack)) {
                double dis = entity.m_20182_().m_82554_(target.m_20182_());
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12437_, SoundSource.NEUTRAL, 0.5f, 0.4f / (entity.m_9236_().f_46441_.m_188501_() * 0.4f + 0.8f));
                if (!entity.m_9236_().f_46443_) {
                    ThrownPotion potion = new ThrownPotion(entity.m_9236_(), (LivingEntity)entity);
                    potion.m_37446_(stack);
                    potion.m_37251_((Entity)entity, entity.m_146909_(), entity.m_146908_(), -30.0f, 0.2f + (float)(dis * 0.05), 1.2f);
                    EntityFlags.get((Entity)potion).isThrownEntity = true;
                    entity.m_9236_().m_7967_((Entity)potion);
                }
            }
        }

        @Override
        public int cooldown() {
            return 85;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean applies(ItemStack stack) {
            return AIUtils.isBadPotion(stack);
        }
    };
    public static final ItemAI CROSSBOWS = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            ItemStack stack = entity.m_21120_(hand);
            float vel = CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.6f : 3.15f;
            CrossbowItem.m_40887_((Level)entity.m_9236_(), (LivingEntity)entity, (InteractionHand)hand, (ItemStack)stack, (float)vel, (float)1.0f);
            CrossbowItem.m_40884_((ItemStack)stack, (boolean)false);
        }

        @Override
        public int cooldown() {
            return 20;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STANDING;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean useHand() {
            return true;
        }

        @Override
        public int maxUseCount(Mob entity, InteractionHand hand) {
            return CrossbowItem.m_40939_((ItemStack)entity.m_21120_(hand)) + 5;
        }
    };
    public static final ItemAI BOWS = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            AIUtils.attackWithArrows(entity, target, BowItem.m_40661_((int)entity.m_21252_()));
        }

        @Override
        public int cooldown() {
            return 30;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean useHand() {
            return true;
        }
    };
    public static final ItemAI SHIELDS = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
        }

        @Override
        public int cooldown() {
            return 60;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.OFF;
        }

        @Override
        public boolean useHand() {
            return true;
        }

        @Override
        public int maxUseCount(Mob entity, InteractionHand hand) {
            return 75;
        }

        @Override
        public boolean isIncompatibleWith(LivingEntity entity, ItemStack stack) {
            return stack.m_41720_() instanceof CrossbowItem || entity instanceof AbstractSkeleton && stack.m_41720_() instanceof BowItem;
        }
    };
    public static final ItemAI SNOWBALL = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (entity.m_9236_().f_46441_.m_188501_() * 0.4f + 0.8f));
            if (!entity.m_9236_().f_46443_) {
                Snowball snowball = new Snowball(entity.m_9236_(), (LivingEntity)entity);
                snowball.m_37251_((Entity)entity, entity.m_146909_(), entity.m_146908_(), 0.0f, 1.5f, 1.0f);
                EntityFlags.get((Entity)snowball).isThrownEntity = true;
                entity.m_9236_().m_7967_((Entity)snowball);
            }
        }

        @Override
        public int cooldown() {
            return 25;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI ENDER_PEARL = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            double dis = entity.m_20182_().m_82557_(target.m_20182_());
            if (dis > 49.0) {
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (entity.m_9236_().f_46441_.m_188501_() * 0.4f + 0.8f));
                if (!entity.m_9236_().f_46443_) {
                    Vec3 v1 = entity.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_(16.0);
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    if (entity.m_20182_().m_82546_(target.m_20182_()).m_82553_() > 16.0) {
                        x = v1.f_82479_;
                        y = v1.f_82480_;
                        z = v1.f_82481_;
                    }
                    ThrownEnderpearl pearl = new ThrownEnderpearl(entity.m_9236_(), (LivingEntity)entity);
                    AIUtils.setHeadingToPosition((ThrowableProjectile)pearl, target.m_20185_() - x, target.m_20186_() - y, target.m_20189_() - z, 1.5f, 3.0f);
                    entity.m_9236_().m_7967_((Entity)pearl);
                }
            }
        }

        @Override
        public int cooldown() {
            return 35;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI LAVABUCKET = new ItemAI(){

        @Override
        public void attack(Mob entity, LivingEntity target, InteractionHand hand) {
            double dis = entity.m_20182_().m_82554_(target.m_20182_());
            if (dis < 8.0 && AIUtils.tryPlaceLava(entity.m_9236_(), BlockPos.m_274561_((double)(target.m_20185_() - 2.0 + (double)entity.m_9236_().f_46441_.m_188503_(4)), (double)(target.m_20186_() - 1.0 + (double)entity.m_9236_().f_46441_.m_188503_(2)), (double)(target.m_20189_() - 2.0 + (double)entity.m_9236_().f_46441_.m_188503_(4))))) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 240, 1, true, false));
            }
        }

        @Override
        public int cooldown() {
            return 80;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
}

