/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.utils;

import com.sofodev.armorplus.registry.item.armor.APRepair;
import com.sofodev.armorplus.utils.Loader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public final class Utils {
    public static ItemStack[] emptyArmor = new ItemStack[4];
    public static EquipmentSlot[] equipmentSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public static List<String> boxList(String[] objects) {
        return Arrays.stream(objects).collect(Collectors.toList());
    }

    public static List<Integer> boxList(int[] objects) {
        return Arrays.stream(objects).boxed().collect(Collectors.toList());
    }

    public static int convertToSeconds(int seconds) {
        return seconds * 20;
    }

    public static ItemStack checkNBT(ItemStack stack) {
        if (stack.m_41783_() == null) {
            stack.m_41751_(new CompoundTag());
        }
        return stack;
    }

    public static ItemStack setUnbreakable(ItemStack stack) {
        Utils.checkNBT(stack);
        stack.m_41783_().m_128379_("Unbreakable", true);
        return stack;
    }

    public static ItemStack getStackFromSlot(Player player, EquipmentSlot slot) {
        return player.m_6844_(slot);
    }

    public static String setName(String name) {
        return String.format("%s.%s", "armorplus", name);
    }

    public static NonNullList<ItemStack> getItemStacks(Item ... items) {
        NonNullList list = NonNullList.m_122779_();
        if (items != null) {
            Arrays.stream(items).map(Utils::getItemStack).forEachOrdered(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public static NonNullList<ItemStack> getItemStacks(ItemStack ... items) {
        NonNullList list = NonNullList.m_122779_();
        list.addAll(Arrays.asList(items));
        return list;
    }

    public static ItemStack getItemStack(Object type, int amount) {
        if (type instanceof String) {
            return new ItemStack((ItemLike)Objects.requireNonNull(Utils.getItemByName((String)type)), amount);
        }
        if (type instanceof Block) {
            return new ItemStack((ItemLike)((Block)type), amount);
        }
        return type instanceof Item ? new ItemStack((ItemLike)((Item)type), amount) : ItemStack.f_41583_;
    }

    public static ItemStack getItemStack(Object type) {
        if (type instanceof String) {
            return Utils.getItemStack(Utils.getItemByName((String)type), 0);
        }
        if (type instanceof Block) {
            return Utils.getItemStack(type, 0);
        }
        if (type instanceof Item) {
            return Utils.getItemStack(type, 0);
        }
        return type instanceof ItemStack ? (ItemStack)type : ItemStack.f_41583_;
    }

    public static String getUnlocalizedNames(ItemStack stack, String key, String ... names) {
        for (int i = 0; i < names.length; ++i) {
            if (stack.m_41773_() != i) continue;
            return key + names[i];
        }
        return key;
    }

    public static Item getItemByName(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)name));
    }

    public static Item getAPItem(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(Utils.setRL(name));
    }

    public static ItemStack getAPItemStack(String name) {
        return new ItemStack((ItemLike)Utils.getAPItem(name));
    }

    public static Item getAPItem(ResourceKey<Item> key) {
        return (Item)ForgeRegistries.ITEMS.getDelegateOrThrow(key).get();
    }

    public static ItemStack createSingleStack(ItemLike item) {
        return new ItemStack(item, 1);
    }

    public static Block getAPBlock(String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(Utils.setRL(name));
    }

    public static ResourceLocation setRL(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"armorplus", (String)path);
    }

    public static ResourceLocation setVanillaLocation(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static String setLocation(String path) {
        return String.format("%s:%s", "armorplus", path);
    }

    public static boolean isNotEmpty(ItemStack stack) {
        return !stack.m_41619_();
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack.m_41619_();
    }

    public static boolean isNotNull(Object object) {
        return object != null;
    }

    public static boolean areNotNull(Object object1, Object object2) {
        return object1 != null && object2 != null;
    }

    public static boolean isNotNullNorEmpty(String object) {
        return Utils.isNotNull(object) && !Objects.equals(object, "");
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNullOrEmpty(String object) {
        return Utils.isNull(object) || Objects.equals(object, "");
    }

    public static ItemStack getTCIngot(int meta) {
        if (Loader.TCONSTRUCT.isLoaded()) {
            Item ingot = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)"tconstruct:ingots"));
            if (ingot != null) {
                return new ItemStack((ItemLike)ingot, 1);
            }
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public static Path getForgeConfig() {
        return FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath());
    }

    public static Path getModConfig() {
        return Utils.getForgeConfig().resolve("armorplus.json");
    }

    public static boolean allowsFlightByDefault(Player player) {
        return player.m_150110_().f_35937_ || player.m_5833_();
    }

    public static List<ItemStack> getRepairStacks(APRepair repair) {
        boolean isItem;
        boolean isString = !repair.getRepair().isEmpty();
        boolean isStack = !repair.getRepairStacks().isEmpty();
        boolean bl = isItem = !repair.getRepairItems().isEmpty();
        if (isString) {
            return repair.getRepair().stream().map(Utils::getAPItem).map(ItemStack::new).collect(Collectors.toList());
        }
        if (isItem) {
            return repair.getRepairItems().stream().map(ItemStack::new).collect(Collectors.toList());
        }
        if (isStack) {
            return repair.getRepairStacks();
        }
        return Collections.emptyList();
    }

    @Nullable
    public static ItemEntity spawnAtLocation(Player player, ItemStack stack, BlockPos pos) {
        if (stack.m_41619_() || player.m_9236_().f_46443_) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(player.m_9236_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
        itementity.m_32060_();
        if (player.captureDrops() != null) {
            player.captureDrops().add(itementity);
        } else {
            player.m_9236_().m_7967_((Entity)itementity);
        }
        return itementity;
    }

    static {
        Arrays.fill(emptyArmor, ItemStack.f_41583_);
    }
}

