/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.utils;

import com.sofodev.armorplus.registry.item.extra.BuffInstance;
import com.sofodev.armorplus.registry.item.tool.properties.tool.IAPTool;
import com.sofodev.armorplus.utils.RomanNumeralUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class ToolTipUtils {
    public static void showInfo(List<Component> tooltip, KeyMapping keyBinding, ChatFormatting formatting) {
        tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.GRAY, "tooltip.armorplus.shift.showinfo", ToolTipUtils.translate(formatting, keyBinding.m_90860_(), new Object[0])));
    }

    public static void appendArrowHoverText(List<Component> tooltip, Component effect, double damage, ChatFormatting formatting) {
        KeyMapping keyBindSneak = Minecraft.m_91087_().f_91066_.f_92090_;
        if (Screen.m_96638_()) {
            tooltip.add((Component)ToolTipUtils.translate("tooltip.armorplus.arrow.ability_desc", effect));
            tooltip.add((Component)ToolTipUtils.translate("tooltip.armorplus.arrow.ability", damage));
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, formatting);
        }
    }

    public static void addBuffInformation(IAPTool tool, List<Component> tooltip, String condition, boolean applyToSelf, boolean enabled) {
        if (!tool.getBuffInstances().get().isEmpty()) {
            tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.YELLOW, "tooltip.armorplus.condition", enabled ? "" : "(DISABLED)"));
            tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.GOLD, "tooltip.armorplus.condition." + condition, new Object[0]));
            tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.GREEN, "tooltip.armorplus." + (applyToSelf ? "provides" : "applies"), new Object[0]));
            for (BuffInstance buff : tool.getBuffInstances().get()) {
                int lvl = buff.getAmplifier() + 1;
                String theLvl = lvl > 0 ? " " + RomanNumeralUtil.generate(lvl) : "";
                tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.DARK_AQUA, "tooltip.armorplus.buff", buff.getTranslatedName(), theLvl));
            }
        }
    }

    public static void addExperimentalItemInformation(List<Component> tooltip) {
        tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.RED, "tooltip.armorplus.not_accessible", new Object[0]));
        tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.RED, "tooltip.armorplus.not_accessible.2", new Object[0]));
        tooltip.add((Component)ToolTipUtils.translate(ChatFormatting.RED, "tooltip.armorplus.not_accessible.3", new Object[0]));
    }

    public static MutableComponent translate(TextColor color, String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args).m_6270_(Style.f_131099_.m_131148_(color));
    }

    public static MutableComponent translate(Style style, String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args).m_6270_(style);
    }

    public static MutableComponent translate(ChatFormatting formatting, String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args).m_130940_(formatting);
    }

    public static MutableComponent translate(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }
}

