/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.item.tool.properties.tool;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.registry.item.APRarity;
import com.sofodev.armorplus.registry.item.extra.BuffInstance;
import com.sofodev.armorplus.registry.item.extra.DeBuff;
import com.sofodev.armorplus.registry.item.tool.properties.tool.APToolProperties;
import com.sofodev.armorplus.registry.item.tool.properties.tool.IAPTool;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum APToolMaterial implements IAPTool
{
    COAL_MAT(APRarity.COAL, (Tier)APToolProperties.COAL_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.BLINDNESS, 0, 10))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.coalMaterial;
        }
    }
    ,
    REDSTONE_MAT(APRarity.REDSTONE, (Tier)APToolProperties.REDSTONE_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.MINING_FATIGUE, 1, 10))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.redstoneMaterial;
        }
    }
    ,
    LAPIS_MAT(APRarity.LAPIS, (Tier)APToolProperties.LAPIS_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.NAUSEA, 0, 10))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.lapisMaterial;
        }
    }
    ,
    EMERALD_MAT(APRarity.EMERALD, (Tier)APToolProperties.EMERALD_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.SLOWNESS, 0, 20))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.emeraldMaterial;
        }
    }
    ,
    OBSIDIAN_MAT(APRarity.OBSIDIAN, (Tier)APToolProperties.OBSIDIAN_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WEAKNESS, 2, 20))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.obsidianMaterial;
        }
    }
    ,
    INFUSED_LAVA_MAT(APRarity.INFUSED_LAVA, (Tier)APToolProperties.INFUSED_LAVA_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.IGNITE))){

        @Override
        public void onBlockMined(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity player) {
            if (player instanceof Player) {
                ArmorPlus.SMELTING_MAP.forEach((block, item) -> {
                    if (block == state.m_60734_()) {
                        world.m_46953_(pos, false, (Entity)player);
                        Utils.spawnAtLocation((Player)player, new ItemStack(item), pos);
                    }
                });
            }
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.infusedLavaMaterial;
        }
    }
    ,
    GUARDIAN_MAT(APRarity.GUARDIAN, (Tier)APToolProperties.GUARDIAN_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WEAKNESS, 1, 4), new BuffInstance(DeBuff.NAUSEA, 1, 20))){

        @Override
        public void onBlockMined(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity player) {
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.guardianMaterial;
        }
    }
    ,
    SUPER_STAR_MAT(APRarity.SUPER_STAR, (Tier)APToolProperties.SUPER_STAR_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WITHER, 1, 4), new BuffInstance(DeBuff.GLOWING, 0, 20))){

        @Override
        public void onBlockMined(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity player) {
            if (state == Blocks.f_50069_.m_49966_() && this.random.nextInt(3) == 1) {
                player.m_5552_(new ItemStack((ItemLike)Items.f_42048_, 1), 0.0f);
            }
            if (state == Blocks.f_49992_.m_49966_() && this.random.nextInt(3) == 1) {
                player.m_5552_(new ItemStack((ItemLike)Items.f_42049_, 1), 0.0f);
            }
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.superStarMaterial;
        }
    }
    ,
    ENDER_DRAGON_MAT(APRarity.ENDER_DRAGON, (Tier)APToolProperties.ENDER_DRAGON_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WITHER, 3, 4), new BuffInstance(DeBuff.SLOWNESS, 1, 20))){

        @Override
        public void onBlockMined(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity player) {
            if (state == Blocks.f_50259_.m_49966_() && this.random.nextInt(3) == 1) {
                player.m_5552_(new ItemStack((ItemLike)Items.f_42584_, 1), 0.0f);
            }
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.enderDragonMaterial;
        }
    }
    ,
    SLAYER_MAT(APRarity.SLAYER, (Tier)APToolProperties.SLAYER_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WITHER, 3, 4), new BuffInstance(DeBuff.SLOWNESS, 1, 20), new BuffInstance(DeBuff.GLOWING, 0, 20), new BuffInstance(DeBuff.WEAKNESS, 1, 4), new BuffInstance(DeBuff.NAUSEA, 1, 20))){

        @Override
        public void onBlockMined(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity player) {
            if (state == Blocks.f_50259_.m_49966_() && this.random.nextInt(3) == 1) {
                player.m_5552_(new ItemStack((ItemLike)Items.f_42584_, 1), 0.0f);
            }
            if (state == Blocks.f_50069_.m_49966_() && this.random.nextInt(3) == 1) {
                player.m_5552_(new ItemStack((ItemLike)Items.f_42048_, 1), 0.0f);
            }
            if (state == Blocks.f_49992_.m_49966_() && this.random.nextInt(3) == 1) {
                player.m_5552_(new ItemStack((ItemLike)Items.f_42049_, 1), 0.0f);
            }
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.slayerMaterial;
        }
    };

    public final Random random = new Random();
    private final Tier properties;
    private final Supplier<List<BuffInstance>> buffs;
    private final Rarity rarity;

    private APToolMaterial(APRarity rarity, Tier properties, Supplier<List<BuffInstance>> buffs) {
        this(rarity.getRarity(), properties, buffs);
    }

    private APToolMaterial(APRarity rarity, Tier properties) {
        this(rarity.getRarity(), properties, Collections::emptyList);
    }

    private APToolMaterial(Rarity rarity, Tier properties, Supplier<List<BuffInstance>> buffs) {
        this.rarity = rarity;
        this.properties = properties;
        this.buffs = buffs;
    }

    private static List<BuffInstance> withBuffs(BuffInstance ... buffs) {
        return Arrays.asList(buffs);
    }

    @Override
    public Tier get() {
        return this.properties;
    }

    @Override
    public Supplier<List<BuffInstance>> getBuffInstances() {
        return this.buffs;
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH).replace("_mat", "");
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    public String toString() {
        return "APToolMaterial{random=" + String.valueOf(this.random) + ", properties=" + String.valueOf(this.properties) + ", buffs=" + String.valueOf(this.buffs) + ", rarity=" + String.valueOf(this.rarity) + "}";
    }
}

