/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.item.special;

import java.util.Locale;

public enum Element {
    NONE,
    EARTH("wind", "fire"),
    WIND("water", "earth"),
    WATER("fire", "wind"),
    FIRE("earth", "water"),
    LIGHT("dark", "light"),
    DARK("light", "dark");

    private final String strongerAgainst;
    private final String weakerAgainst;

    private Element() {
        this("none", "none");
    }

    private Element(String strongerAgainst, String weakerAgainst) {
        this.strongerAgainst = strongerAgainst;
        this.weakerAgainst = weakerAgainst;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public String getStrongerAgainst() {
        return this.strongerAgainst;
    }

    public String getWeakerAgainst() {
        return this.weakerAgainst;
    }

    public double getEffectiveness(Element defending) {
        if (this.getStrongerAgainst().equals(defending.getName())) {
            return 1.4;
        }
        if (this.getWeakerAgainst().equals(defending.getName())) {
            return 0.6;
        }
        if (this.equals((Object)defending)) {
            return 0.0;
        }
        return 1.0;
    }

    public static double getEffectiveness(Element attacking, Element defending) {
        if (attacking.getStrongerAgainst().equals(defending.getName())) {
            return 1.4;
        }
        if (attacking.getWeakerAgainst().equals(defending.getName())) {
            return 0.6;
        }
        if (attacking.equals((Object)defending)) {
            return 0.0;
        }
        return 1.0;
    }
}

